/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.resource.manager;

import com.atlassian.jira.mobile.resource.manager.MobileJavaProxies;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.JavascriptWebResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobileWebResourceManager
extends WebResourceManagerImpl {
    public MobileWebResourceManager(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration resourceBatchingConfiguration) {
        super(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, MobileJavaProxies.resourceBatchingConfigurationProxy(resourceBatchingConfiguration));
    }

    public Boolean isAnalyticsInstalled() {
        String moduleCompleteKey = "com.atlassian.analytics.analytics-client:js-events";
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleCompleteKey);
        return moduleDescriptor != null;
    }

    public String getAnalyticsTags() {
        String moduleCompleteKey = "com.atlassian.analytics.analytics-client:js-events";
        if (!this.isAnalyticsInstalled().booleanValue()) {
            return "";
        }
        JavascriptWebResource formatter = new JavascriptWebResource();
        List<String> jsFilenames = Arrays.asList("store.js", "atlassian-analytics.js");
        StringBuilder builder = new StringBuilder();
        HashMap params = Maps.newHashMap();
        for (String filename : jsFilenames) {
            String resourceUrl = this.getStaticPluginResource(moduleCompleteKey, filename, UrlMode.RELATIVE);
            builder.append(formatter.formatResource(resourceUrl, (Map)params));
        }
        return builder.toString();
    }
}

