/**
 * Simple base View class for all other full-page views to inherit from.
 *
 * Handles common logic for all full-page views, such as header/content separation and loading spinners.
 */
define('layout/base/page-view', ['zepto', 'backbone'], function ($, Backbone) {
    var PageView = Backbone.View.extend({
        header: null,
        hasSpinner: false,

        /**
         * Show a full page loading spinner (with cancel) that prevents tap/scroll
         */
        showLoading: function () {
            if (this.header) {
                this.header.showLoading('page');
                this.hasSpinner = true;
            }
        },

        /**
         * Show a small loading spinner in the header, for use with in-page actions
         */
        showHeaderLoading: function () {
            if (this.header) {
                this.header.showLoading('header');
                this.hasSpinner = true;
            }
        },

        /**
         * Remove any active loading spinners
         */
        hideLoading: function () {
            if (this.hasSpinner) {
                this.header.hideLoading();
            }
        },

        showSuccess: function () {
            if (this.header) {
                this.header.showSuccess();
            }
        },

        /**
         * Cancel any AJAX requests that are currently active for this view
         */
        cancelLoading: function () {
            var ajax = require('util/ajax');
            ajax.cancelActiveRequests();
        }
    });

    return PageView;
});