/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter.mapper;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.mobile.servlet.filter.mapper.URLTracker;
import com.atlassian.jira.security.PermissionManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ViewIssueURLTracker
implements URLTracker {
    private PermissionManager permissionManager;
    private IssueManager issueManager;
    private static final Pattern PATTERN = Pattern.compile("\\/browse\\/((?:.+)-(?:.+))");
    private static final String PREFIX = "/browse/";
    private static final String COMMENT_ID_PARAM = "focusedCommentId";

    @Override
    public boolean matches(String path) {
        Matcher matcher = PATTERN.matcher(path);
        boolean correctPrefix = path.startsWith(PREFIX);
        boolean matchesPattern = matcher.matches();
        return correctPrefix && matchesPattern;
    }

    @Override
    public String map(String path, HttpServletRequest request) {
        if (this.matches(path)) {
            Matcher matcher = PATTERN.matcher(path);
            matcher.matches();
            String issue = matcher.group(1);
            if (issue != null) {
                String commentId = request.getParameter(COMMENT_ID_PARAM);
                if (StringUtils.isNotBlank((String)commentId)) {
                    return String.format("issue/%s/comment/%s", issue, commentId);
                }
                return String.format("issue/%s", issue);
            }
        }
        return null;
    }

    @Override
    public boolean requiresLogin(String path, HttpServletRequest request, User user) {
        if (this.matches(path)) {
            Matcher matcher = PATTERN.matcher(path);
            matcher.matches();
            String issueKey = matcher.group(1).toUpperCase();
            MutableIssue issue = this.getIssueManager().getIssueObject(issueKey);
            if (issue != null) {
                return !this.getPermissionManager().hasPermission(10, (Issue)issue, user);
            }
        }
        return false;
    }

    private PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = (PermissionManager)ComponentAccessor.getComponent(PermissionManager.class);
            return this.permissionManager;
        }
        return this.permissionManager;
    }

    private IssueManager getIssueManager() {
        if (this.issueManager == null) {
            this.issueManager = (IssueManager)ComponentAccessor.getComponent(IssueManager.class);
            return this.issueManager;
        }
        return this.issueManager;
    }
}

