/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.mobile.rest.fields.AssignResponseBean;
import com.atlassian.jira.mobile.rest.util.BaseRestResource;
import com.atlassian.jira.mobile.rest.util.IssueFinder;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/assignee")
public class AssignResource
extends BaseRestResource {
    private final IssueFinder issueFinder;
    private final IssueService issueService;
    private final JiraBaseUrls jiraBaseUrls;

    public AssignResource(IssueFinder issueFinder, IssueService issueService, JiraAuthenticationContext jiraAuthenticationContext, JiraBaseUrls jiraBaseUrls) {
        super(AssignResource.class, jiraAuthenticationContext);
        this.issueFinder = issueFinder;
        this.issueService = issueService;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @PUT
    @Path(value="/{issueIdOrKey}")
    public Response assign(@PathParam(value="issueIdOrKey") String issueIdOrKey, UserBean assigneeBean) {
        String assigneeName = assigneeBean == null ? null : assigneeBean.getName();
        MutableIssue issue = this.issueFinder.findIssue(issueIdOrKey);
        IssueService.AssignValidationResult issueValidationResult = this.issueService.validateAssign(this.getLoggedInUser(), issue.getId(), assigneeName);
        if (!issueValidationResult.isValid()) {
            return this.error(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)issueValidationResult.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.assign(this.getLoggedInUser(), issueValidationResult);
        if (!issueResult.isValid()) {
            return this.error(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)issueResult.getErrorCollection()));
        }
        UserJsonBean assignee = UserJsonBean.shortBean((User)issueResult.getIssue().getAssignee(), (JiraBaseUrls)this.jiraBaseUrls);
        boolean canAssignToSelf = this.getIsSelfAssignable(this.getLoggedInUser(), (Issue)issueResult.getIssue());
        return Response.ok((Object)new AssignResponseBean(assignee, canAssignToSelf)).cacheControl(CacheControl.never()).build();
    }

    protected Response error(ErrorCollection errors) {
        return Response.status((int)errors.getStatus()).entity((Object)errors).cacheControl(CacheControl.never()).build();
    }

    private boolean getIsSelfAssignable(User user, Issue issue) {
        if (user != null) {
            IssueService.AssignValidationResult result = this.issueService.validateAssign(user, issue.getId(), user.getName());
            boolean isEditable = this.issueService.isEditable(issue, user);
            boolean isAssignee = user.equals(issue.getAssignee());
            return result.isValid() && isEditable && !isAssignee;
        }
        return false;
    }
}

