/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.utils;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.json.JSONArray;
import com.atlassian.json.JSONException;
import com.atlassian.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class JSONKit {
    public static JSONObject put(JSONObject parentJSON, String propertyName, Object child) {
        Assertions.notNull((String)"parentJSON", (Object)parentJSON);
        Assertions.notNull((String)"propertyName", (Object)propertyName);
        try {
            parentJSON.put(propertyName, child);
        }
        catch (JSONException e) {
            throw new RuntimeException("I dont see how this can ever happen but if you are seeing this then they are some pretty pathetic last words eh?", e);
        }
        return parentJSON;
    }

    public static JSONObject get(JSONObject json, String propertyName, JSONObject defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        Assertions.notNull((String)"propertyName", (Object)propertyName);
        JSONObject property = json.optJSONObject(propertyName);
        return property == null ? defaultValue : property;
    }

    public static JSONObject get(JSONObject json, String propertyName) {
        return JSONKit.get(json, propertyName, new JSONObject());
    }

    public static JSONArray getArray(JSONObject json, String propertyName, JSONArray defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        Assertions.notNull((String)"propertyName", (Object)propertyName);
        JSONArray property = json.optJSONArray(propertyName);
        return property == null ? defaultValue : property;
    }

    public static JSONArray getArray(JSONObject json, String propertyName) {
        return JSONKit.getArray(json, propertyName, new JSONArray());
    }

    public static String getString(JSONObject json, String propertyName, String defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        Assertions.notNull((String)"propertyName", (Object)propertyName);
        String property = json.optString(propertyName);
        return property == null ? defaultValue : property;
    }

    public static String getString(JSONObject json, String propertyName) {
        return JSONKit.getString(json, propertyName, "");
    }

    public static Long getLong(JSONObject json, String propertyName, Long defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        Assertions.notNull((String)"propertyName", (Object)propertyName);
        Long property = json.optLong(propertyName);
        return property == null ? defaultValue : property;
    }

    public static Long getLong(JSONObject json, String propertyName) {
        return JSONKit.getLong(json, propertyName, (Long)0L);
    }

    public static Boolean getBoolean(JSONObject json, String propertyName, Boolean defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        Assertions.notNull((String)"propertyName", (Object)propertyName);
        Boolean property = json.optBoolean(propertyName);
        return property == null ? defaultValue : property;
    }

    public static Boolean getBoolean(JSONObject json, String propertyName) {
        return JSONKit.getBoolean(json, propertyName, Boolean.FALSE);
    }

    public static JSONObject get(JSONArray json, int index, JSONObject defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        JSONObject property = json.optJSONObject(index);
        return property == null ? defaultValue : property;
    }

    public static JSONObject get(JSONArray json, int index) {
        return JSONKit.get(json, index, new JSONObject());
    }

    public static JSONArray getArray(JSONArray json, int index, JSONArray defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        JSONArray property = json.optJSONArray(index);
        return property == null ? defaultValue : property;
    }

    public static JSONArray getArray(JSONArray json, int index) {
        return JSONKit.getArray(json, index, new JSONArray());
    }

    public static String getString(JSONArray json, int index, String defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        String property = json.optString(index);
        return property == null ? defaultValue : property;
    }

    public static String getString(JSONArray json, int index) {
        return JSONKit.getString(json, index, "");
    }

    public static Long getLong(JSONArray json, int index, Long defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        Long property = json.optLong(index);
        return property == null ? defaultValue : property;
    }

    public static Long getLong(JSONArray json, int index) {
        return JSONKit.getLong(json, index, (Long)0L);
    }

    public static Boolean getBoolean(JSONArray json, int index, Boolean defaultValue) {
        Assertions.notNull((String)"json", (Object)json);
        Boolean property = json.optBoolean(index);
        return property == null ? defaultValue : property;
    }

    public static Boolean getBoolean(JSONArray json, int index) {
        return JSONKit.getBoolean(json, index, Boolean.FALSE);
    }

    public static JSONObject to(String jsonStr, JSONObject defaultValue) {
        try {
            if (StringUtils.isBlank((String)jsonStr)) {
                return defaultValue;
            }
            return new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    public static JSONObject to(String jsonStr) {
        return JSONKit.to(jsonStr, new JSONObject());
    }

    public static JSONObject to(InputStream stream) throws IOException {
        String jsonStr = IOUtils.toString((InputStream)stream);
        return JSONKit.to(jsonStr, new JSONObject());
    }

    public static JSONArray toArray(String jsonStr, JSONArray defaultValue) {
        try {
            if (StringUtils.isBlank((String)jsonStr)) {
                return defaultValue;
            }
            return new JSONArray(jsonStr);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    public static JSONArray toArray(String jsonStr) {
        return JSONKit.toArray(jsonStr, new JSONArray());
    }
}

