/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.mobile.compat.lasso.LassoPluginAccessor;
import com.atlassian.jira.mobile.resource.filter.CSSFilter;
import com.atlassian.jira.mobile.resource.filter.JSFilter;
import com.atlassian.jira.mobile.resource.manager.MobileResourceServerServletUrlRewriter;
import com.atlassian.jira.mobile.resource.manager.MobileWebResourceManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.NullWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileServlet
extends HttpServlet {
    private SoyTemplateRenderer soyTemplateRenderer;
    private final MobileWebResourceManager webResourceManager;
    private final com.atlassian.sal.api.user.UserManager userManager;
    private final UserManager jiraUserManager;
    private final ApplicationProperties applicationProperties;
    private final JiraBaseUrls jiraBaseUrls;
    private final LassoPluginAccessor lassoPluginAccessor;

    public MobileServlet(com.atlassian.sal.api.user.UserManager userManager, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ApplicationProperties applicationProperties, UserManager jiraUserManager, JiraBaseUrls jiraBaseUrls, LassoPluginAccessor lassoPluginAccessor, ResourceBatchingConfiguration resourceBatchingConfiguration) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.webResourceManager = new MobileWebResourceManager(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, resourceBatchingConfiguration);
        this.jiraUserManager = jiraUserManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.lassoPluginAccessor = lassoPluginAccessor;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Boolean isOnDemand = ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(CoreFeatures.ON_DEMAND);
        Boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode"));
        Map<String, Object> context = this.getHomeContext();
        context.put("username", this.userManager.getRemoteUsername(request));
        context.put("user", this.getUser(request));
        context.put("contextPath", request.getContextPath());
        context.put("appTitle", this.applicationProperties.getString("jira.title"));
        context.put("isOnDemand", isOnDemand);
        context.put("isLasso", this.isLassoEnabled());
        context.put("isAnalyticsEnabled", isDevMode == false && this.webResourceManager.isAnalyticsInstalled() != false);
        String templateName = "homePage";
        String pageParam = request.getParameter("page");
        if ("login".equals(pageParam)) {
            templateName = "login";
            context.put("loginPath", request.getContextPath() + "/rest/mobile/1.0/login");
            context.put("destination", request.getParameter("os_destination"));
        }
        String result = this.renderSoyTemplate("com.atlassian.jira.mobile:mobile-layout", "AtlassianMobile.Templates.JIRA.layout." + templateName, context);
        response.getWriter().append(result);
    }

    private Map<String, Object> getHomeContext() {
        HashMap context = Maps.newHashMap();
        HashMap resources = Maps.newHashMap();
        this.webResourceManager.includeResources((Writer)new NullWriter(), UrlMode.RELATIVE);
        this.webResourceManager.requireResourcesForContext("mob-general");
        String footerResources = this.webResourceManager.getRequiredResources(UrlMode.RELATIVE, new JSFilter());
        String analyticsJS = this.webResourceManager.getAnalyticsTags();
        footerResources = footerResources + analyticsJS;
        resources.put("header", this.reMap(this.webResourceManager.getRequiredResources(UrlMode.RELATIVE, new CSSFilter())));
        resources.put("footer", this.reMap(footerResources));
        context.put("resources", resources);
        return context;
    }

    private UserJsonBean getUser(HttpServletRequest request) {
        String userName = this.userManager.getRemoteUsername(request);
        User user = this.jiraUserManager.getUser(userName);
        return UserJsonBean.shortBean((User)user, (JiraBaseUrls)this.jiraBaseUrls);
    }

    private String renderSoyTemplate(String pluginKey, String template, Map<String, Object> context) {
        try {
            return this.getSoyTemplateRenderer().render(pluginKey, template, context);
        }
        catch (SoyException e) {
            return "";
        }
    }

    private SoyTemplateRenderer getSoyTemplateRenderer() {
        if (this.soyTemplateRenderer == null) {
            this.soyTemplateRenderer = (SoyTemplateRenderer)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
            return this.soyTemplateRenderer;
        }
        return this.soyTemplateRenderer;
    }

    private String reMap(String s) {
        return MobileResourceServerServletUrlRewriter.apply(s);
    }

    private boolean isLassoEnabled() {
        return this.lassoPluginAccessor.isLassoEnabled();
    }
}

