/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.security.login.LoginProperties;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.mobile.rest.util.BaseRestResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/login")
@AnonymousAllowed
public class MobileAuthenticationResource
extends BaseRestResource {
    private final LoginService loginService;
    private final JiraBaseUrls jiraBaseUrls;

    public MobileAuthenticationResource(JiraAuthenticationContext jiraAuthenticationContext, LoginService loginService, JiraBaseUrls jiraBaseUrls) {
        super(MobileAuthenticationResource.class, jiraAuthenticationContext);
        this.loginService = loginService;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @POST
    @Produces(value={"application/json"})
    public Response getTestMethod(final @Context HttpServletRequest request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                LoginProperties loginProperties = MobileAuthenticationResource.this.loginService.getLoginProperties(MobileAuthenticationResource.this.jiraAuthenticationContext.getLoggedInUser(), request);
                if (loginProperties.isLoginSucceeded()) {
                    return MobileAuthenticationResource.this.ok(UserJsonBean.shortBean((User)MobileAuthenticationResource.this.getLoggedInUser(), (JiraBaseUrls)MobileAuthenticationResource.this.jiraBaseUrls));
                }
                if (loginProperties.isCaptchaFailure()) {
                    return MobileAuthenticationResource.this.forbiddenRequest("403.login.captcha.required");
                }
                return MobileAuthenticationResource.this.unauthorizedRequest("401.login.unsuccessful");
            }
        });
    }
}

