/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain;

import com.atlassian.jira.rest.client.AddressableEntity;
import com.atlassian.jira.rest.client.IdentifiableEntity;
import com.atlassian.jira.rest.client.NamedEntity;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

public class EntityHelper {
    public static Function<IdentifiableEntity<String>, String> GET_ENTITY_STRING_ID_FUNCTION = new Function<IdentifiableEntity<String>, String>(){

        public String apply(IdentifiableEntity<String> entity) {
            return entity.getId();
        }
    };

    public static Iterable<String> toNamesList(Iterable<? extends NamedEntity> items) {
        return Iterables.transform(items, (Function)new Function<NamedEntity, String>(){

            public String apply(NamedEntity from) {
                return from.getName();
            }
        });
    }

    public static <T> Iterable<String> toStringIdList(Iterable<IdentifiableEntity<T>> items) {
        return Iterables.transform(items, (Function)new Function<IdentifiableEntity<T>, String>(){

            public String apply(IdentifiableEntity<T> from) {
                return from.getId() == null ? null : from.getId().toString();
            }
        });
    }

    public static <T extends NamedEntity> T findEntityByName(Iterable<T> entities, String name) {
        return (T)((NamedEntity)Iterables.find(entities, HasNamePredicate.forName(name)));
    }

    public static <T extends IdentifiableEntity<K>, K> T findEntityById(Iterable<T> entities, K id) {
        return (T)((IdentifiableEntity)Iterables.find(entities, HasIdPredicate.forId(id)));
    }

    public static class AddressEndsWithPredicate
    implements Predicate<AddressableEntity> {
        private final String stringEnding;

        public AddressEndsWithPredicate(String stringEnding) {
            this.stringEnding = stringEnding;
        }

        public boolean apply(AddressableEntity input) {
            return input.getSelf().getPath().endsWith(this.stringEnding);
        }
    }

    public static class HasIdPredicate<T extends IdentifiableEntity<K>, K>
    implements Predicate<T> {
        private final K id;

        public static <X extends IdentifiableEntity<Y>, Y> HasIdPredicate<X, Y> forId(Y id) {
            return new HasIdPredicate(id);
        }

        private HasIdPredicate(K id) {
            this.id = id;
        }

        public boolean apply(T input) {
            return this.id.equals(input.getId());
        }
    }

    public static class HasNamePredicate<T extends NamedEntity>
    implements Predicate<T> {
        private final String name;

        public static <K extends NamedEntity> HasNamePredicate<K> forName(String name) {
            return new HasNamePredicate(name);
        }

        private HasNamePredicate(String name) {
            this.name = name;
        }

        public boolean apply(T input) {
            return this.name.equals(input.getName());
        }
    }
}

