/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class AttachmentKey {
    private final Long attachmentId;
    private final String attachmentFilename;
    private final String issueKey;
    private final String projectKey;

    AttachmentKey(@Nonnull String projectKey, @Nonnull String issueKey, @Nonnull Long attachmentId, @Nonnull String attachmentFilename) {
        this.attachmentId = (Long)Preconditions.checkNotNull((Object)attachmentId);
        this.issueKey = (String)Preconditions.checkNotNull((Object)issueKey);
        this.projectKey = (String)Preconditions.checkNotNull((Object)projectKey);
        this.attachmentFilename = (String)Preconditions.checkNotNull((Object)attachmentFilename);
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public String getAttachmentFilename() {
        return this.attachmentFilename;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentKey that = (AttachmentKey)o;
        return this.attachmentFilename.equals(that.attachmentFilename) && this.attachmentId.equals(that.attachmentId) && this.issueKey.equals(that.issueKey) && this.projectKey.equals(that.projectKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.attachmentId, this.attachmentFilename, this.issueKey, this.projectKey});
    }

    public String toString() {
        return "AttachmentKey{attachmentId=" + this.attachmentId + ", attachmentFilename='" + this.attachmentFilename + '\'' + ", issueKey='" + this.issueKey + '\'' + ", projectKey='" + this.projectKey + '\'' + '}';
    }
}

