/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.permission.GlobalPermissionKey;
import org.ofbiz.core.entity.GenericValue;

@ExperimentalApi
public final class GlobalPermissionEntry {
    private final String permissionKey;
    private final String group;

    public GlobalPermissionEntry(GenericValue permission) {
        this.group = permission.getString("group_id");
        this.permissionKey = permission.getString("permission");
    }

    public GlobalPermissionEntry(String permissionKey, String group) {
        this.permissionKey = permissionKey;
        this.group = group;
    }

    public GlobalPermissionEntry(GlobalPermissionKey permissionKey, String group) {
        this.permissionKey = permissionKey.getKey();
        this.group = group;
    }

    public GlobalPermissionEntry(String permissionKey) {
        this.permissionKey = permissionKey;
        this.group = null;
    }

    public String getPermissionKey() {
        return this.permissionKey;
    }

    @Internal
    public String getGlobalPermissionType() {
        return this.permissionKey;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalPermissionEntry)) {
            return false;
        }
        GlobalPermissionEntry jiraPermission = (GlobalPermissionEntry)o;
        if (this.group != null ? !this.group.equals(jiraPermission.group) : jiraPermission.group != null) {
            return false;
        }
        return !(this.permissionKey != null ? !this.permissionKey.equals(jiraPermission.permissionKey) : jiraPermission.permissionKey != null);
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 71 * result + (this.permissionKey != null ? this.permissionKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Global Permission: [group=" + this.group + "][permissionKey=" + this.permissionKey + "]";
    }
}

