/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.dbc.Assertions;

@PublicApi
public final class Selection {
    private final int topLeftX;
    private final int topLeftY;
    private final int width;
    private final int height;

    public Selection(int topLeftX, int topLeftY, int width, int height) {
        Assertions.not("topLeftX must be positive", topLeftX < 0);
        Assertions.not("topLeftY must be positive", topLeftY < 0);
        Assertions.not("width must be positive", width < 0);
        Assertions.not("height must be positive", height < 0);
        this.topLeftX = topLeftX;
        this.topLeftY = topLeftY;
        this.width = width;
        this.height = height;
    }

    public int getTopLeftX() {
        return this.topLeftX;
    }

    public int getTopLeftY() {
        return this.topLeftY;
    }

    public int getBottomRightX() {
        return this.topLeftX + this.width;
    }

    public int getBottomRightY() {
        return this.topLeftY + this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

