/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.operand;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;

public final class SingleValueOperand
implements Operand {
    public static final String OPERAND_NAME = "SingleValueOperand";
    private final Long longValue;
    private final String stringValue;

    public SingleValueOperand(String stringValue) {
        this.stringValue = Assertions.notNull("stringValue", stringValue);
        this.longValue = null;
    }

    public SingleValueOperand(Long longValue) {
        this.longValue = Assertions.notNull("longValue", longValue);
        this.stringValue = null;
    }

    public SingleValueOperand(QueryLiteral literal) {
        Assertions.notNull("literal", literal);
        if (literal.getLongValue() != null) {
            this.longValue = literal.getLongValue();
            this.stringValue = null;
        } else if (literal.getStringValue() != null) {
            this.stringValue = literal.getStringValue();
            this.longValue = null;
        } else {
            throw new IllegalArgumentException("QueryLiteral '" + literal + "' must contain at least one non-null value");
        }
    }

    @Override
    public String getName() {
        return OPERAND_NAME;
    }

    @Override
    public String getDisplayString() {
        if (this.longValue == null) {
            return "\"" + this.stringValue + "\"";
        }
        return this.longValue.toString();
    }

    @Override
    public <R> R accept(OperandVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleValueOperand that = (SingleValueOperand)o;
        if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) {
            return false;
        }
        return !(this.stringValue != null ? !this.stringValue.equals(that.stringValue) : that.stringValue != null);
    }

    public int hashCode() {
        int result = this.longValue != null ? this.longValue.hashCode() : 0;
        result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Single Value Operand [" + this.getDisplayString() + "]";
    }
}

