/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.List;

@ExperimentalApi
public class Property {
    public static final Function<String, List<String>> SPLIT_STRING = new Function<String, List<String>>(){

        public List<String> apply(String input) {
            return ImmutableList.copyOf((Object[])input.split("\\."));
        }
    };
    private static final Joiner joiner = Joiner.on((char)'.');
    private final List<String> keys;
    private final List<String> objectReferences;

    public Property(List<String> keys, List<String> objectReferences) {
        this.keys = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Collections2.transform(keys, SPLIT_STRING)));
        this.objectReferences = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Collections2.transform(objectReferences, SPLIT_STRING)));
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public List<String> getObjectReferences() {
        return this.objectReferences;
    }

    public String getAsPropertyString() {
        return MessageFormat.format("{0}${1}", this.getKeysAsString(), this.getObjectReferencesAsString());
    }

    public String getKeysAsString() {
        return joiner.join(this.keys);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property property = (Property)obj;
        return Objects.equal(this.keys, property.keys) && Objects.equal(this.objectReferences, property.objectReferences);
    }

    public String toString() {
        return String.format("[%s].%s", this.getKeysAsString(), this.getObjectReferencesAsString());
    }

    public String getObjectReferencesAsString() {
        return joiner.join(this.getObjectReferences());
    }
}

