/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.RedirectSanitiser;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class RedirectSanitiserImpl
implements RedirectSanitiser {
    private static final Logger securityLog = Logger.getLogger((String)"com.atlassian.jira.login.security");
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public RedirectSanitiserImpl(VelocityRequestContextFactory velocityRequestContextFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @Override
    public boolean canRedirectTo(@Nullable String redirectUri) {
        if (redirectUri == null) {
            return true;
        }
        if (redirectUri.startsWith("//")) {
            return false;
        }
        if (redirectUri.startsWith(this.getCanonicalBaseURL())) {
            return true;
        }
        boolean hasScheme = redirectUri.contains(":");
        return !hasScheme;
    }

    @Override
    @Nullable
    public String makeSafeRedirectUrl(@Nullable String redirectUrl) {
        if (redirectUrl == null) {
            return null;
        }
        if (!this.canRedirectTo(redirectUrl)) {
            securityLog.warn((Object)("Potential malicious redirect detected: " + redirectUrl));
            return null;
        }
        return redirectUrl;
    }

    protected String getCanonicalBaseURL() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }
}

