/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.context.PercentageContext;
import com.atlassian.jira.util.dbc.Assertions;
import java.text.MessageFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@Internal
class LoggingContextSink
implements PercentageContext.Sink {
    private final Logger log;
    private String name = "";
    private final String msg;
    private final Level level;

    LoggingContextSink(Logger log, String msg, Level level) {
        Assertions.notNull("logger", log);
        this.log = log;
        this.msg = msg;
        this.level = level;
    }

    LoggingContextSink(Logger log, String msg) {
        this(log, msg, Level.DEBUG);
    }

    @Override
    public void setName(String name) {
        Assertions.notNull("name", name);
        this.name = name;
    }

    @Override
    public void updateProgress(int progress) {
        this.log.log((Priority)this.level, (Object)MessageFormat.format(this.msg, new Integer(progress), this.name));
    }
}

