/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.annotations.PublicApi;

@PublicApi
public enum NotificationType {
    CURRENT_ASSIGNEE("Current_Assignee"),
    REPORTER("Current_Reporter"),
    CURRENT_USER("Remote_User"),
    PROJECT_LEAD("Project_Lead"),
    COMPONENT_LEAD("Component_Lead"),
    SINGLE_USER("Single_User"),
    GROUP("Group_Dropdown"),
    PROJECT_ROLE("Project_Role"),
    SINGLE_EMAIL_ADDRESS("Single_Email_Address"),
    ALL_WATCHERS("All_Watchers"),
    USER_CUSTOM_FIELD_VALUE("User_Custom_Field_Value"),
    GROUP_CUSTOM_FIELD_VALUE("Group_Custom_Field_Value");

    private final String dbCode;

    private NotificationType(String dbCode) {
        this.dbCode = dbCode;
    }

    public String dbCode() {
        return this.dbCode;
    }

    public static NotificationType from(String dbCode) {
        for (NotificationType notificationType : NotificationType.values()) {
            if (!notificationType.dbCode().equals(dbCode)) continue;
            return notificationType;
        }
        throw new IllegalArgumentException("You have to provide a valid mapped string");
    }
}

