/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.mapper;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.imports.project.mapper.AbstractMapper;
import com.atlassian.jira.imports.project.mapper.ProjectImportIdMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.builder.ToStringBuilder;

@PublicApi
public class CustomFieldMapper
extends AbstractMapper
implements ProjectImportIdMapper {
    private final Map idMap = new HashMap();
    private final MultiMap issueToCustomFieldMap;
    private final MultiMap issueTypesInUse = MultiValueMap.decorate(new HashMap(), TreeSet.class);
    private final Map<String, String> issueToIssueTypeMap;
    private final Map<String, String> issueToIssueTypeCache;
    private final Set<String> ignoredCustomFields;

    public CustomFieldMapper() {
        this.issueToCustomFieldMap = MultiValueMap.decorate(new HashMap(), HashSet.class);
        this.issueToIssueTypeMap = new HashMap<String, String>();
        this.issueToIssueTypeCache = new HashMap<String, String>();
        this.ignoredCustomFields = new HashSet<String>();
    }

    public Collection getIssueTypeIdsForRequiredCustomField(String customFieldId) {
        return (Collection)this.issueTypesInUse.get((Object)customFieldId);
    }

    public void flagValueAsRequired(String oldCustomFieldId, String oldIssueId) {
        if (oldCustomFieldId != null && oldIssueId != null) {
            super.flagValueAsRequired(oldCustomFieldId);
            this.issueToCustomFieldMap.put((Object)oldIssueId, (Object)oldCustomFieldId);
        }
    }

    public void flagIssueTypeInUse(String oldIssueId, String oldIssueTypeId) {
        this.issueToIssueTypeCache.put(oldIssueId, oldIssueTypeId);
    }

    public void registerIssueTypesInUse() {
        for (String oldIssueId : this.issueToIssueTypeCache.keySet()) {
            Collection customFields = (Collection)this.issueToCustomFieldMap.remove((Object)oldIssueId);
            if (customFields == null) continue;
            for (Object customField : customFields) {
                String customFieldId = (String)customField;
                String oldIssueTypeId = this.issueToIssueTypeCache.get(oldIssueId);
                this.issueTypesInUse.put((Object)customFieldId, (Object)oldIssueTypeId);
                this.issueToIssueTypeMap.put(oldIssueId, oldIssueTypeId);
            }
        }
        this.issueToIssueTypeCache.clear();
    }

    @Override
    public void registerOldValue(String oldId, String oldKey) {
        super.registerOldValue(oldId, oldKey);
    }

    public String getIssueTypeForIssue(String issueId) {
        return this.issueToIssueTypeMap.get(issueId);
    }

    public boolean isIgnoredCustomField(String customFieldId) {
        return this.ignoredCustomFields.contains(customFieldId);
    }

    public void ignoreCustomField(String customFieldId) {
        this.ignoredCustomFields.add(customFieldId);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldMapper that = (CustomFieldMapper)o;
        if (this.idMap != null ? !((Object)this.idMap).equals(that.idMap) : that.idMap != null) {
            return false;
        }
        if (this.issueToCustomFieldMap != null ? !this.issueToCustomFieldMap.equals(that.issueToCustomFieldMap) : that.issueToCustomFieldMap != null) {
            return false;
        }
        if (this.issueTypesInUse != null ? !this.issueTypesInUse.equals(that.issueTypesInUse) : that.issueTypesInUse != null) {
            return false;
        }
        if (this.getValuesFromImport() != null ? !((Object)this.getValuesFromImport()).equals(that.getValuesFromImport()) : that.getValuesFromImport() != null) {
            return false;
        }
        return !(this.getRequiredOldIds() != null ? !((Object)this.getRequiredOldIds()).equals(that.getRequiredOldIds()) : that.getRequiredOldIds() != null);
    }

    public int hashCode() {
        int result = this.idMap != null ? ((Object)this.idMap).hashCode() : 0;
        result = 31 * result + (this.getValuesFromImport() != null ? ((Object)this.getValuesFromImport()).hashCode() : 0);
        result = 31 * result + (this.issueToCustomFieldMap != null ? this.issueToCustomFieldMap.hashCode() : 0);
        result = 31 * result + (this.getRequiredOldIds() != null ? ((Object)this.getRequiredOldIds()).hashCode() : 0);
        result = 31 * result + (this.issueTypesInUse != null ? this.issueTypesInUse.hashCode() : 0);
        return result;
    }
}

