/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.LocalDateValueValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;

public class LocalDateValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final LocalDateValueValidator localDateValueValidator;

    public LocalDateValidator(JqlOperandResolver operandResolver, JqlLocalDateSupport jqlLocalDateSupport) {
        Assertions.notNull("operandResolver", operandResolver);
        this.localDateValueValidator = new LocalDateValueValidator(operandResolver, jqlLocalDateSupport);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            errors = this.localDateValueValidator.validate(searcher, terminalClause);
        }
        return errors;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS);
    }
}

