/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ClauseContextImpl
implements ClauseContext {
    private static final ClauseContextImpl GLOBAL_CONTEXT = new ClauseContextImpl(Collections.singleton(ProjectIssueTypeContextImpl.createGlobalContext()));
    private final Set<ProjectIssueTypeContext> contexts;

    public static ClauseContext createGlobalClauseContext() {
        return GLOBAL_CONTEXT;
    }

    public ClauseContextImpl() {
        this(Collections.emptySet());
    }

    public ClauseContextImpl(Set<ProjectIssueTypeContext> contexts) {
        this.contexts = Collections.unmodifiableSet(Assertions.containsNoNulls("contexts", contexts));
    }

    @Override
    public Set<ProjectIssueTypeContext> getContexts() {
        return this.contexts;
    }

    @Override
    public boolean containsGlobalContext() {
        return this.contexts.contains(ProjectIssueTypeContextImpl.createGlobalContext());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClauseContextImpl that = (ClauseContextImpl)o;
        return ((Object)this.contexts).equals(that.contexts);
    }

    public int hashCode() {
        return ((Object)this.contexts).hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("contexts", this.contexts).toString();
    }
}

