/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

public class StringSortComparator
extends FieldComparatorSource {
    public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new StringOrdValComparator(numHits, fieldname);
    }

    public static final class StringOrdValComparator
    extends FieldComparator {
        private int[] ords;
        private String[] values;
        private int[] readerGen;
        private int currentReaderGen = -1;
        private String[] lookup;
        private int[] order;
        private final String field;
        private int bottomSlot = -1;
        private int bottomOrd;
        private boolean bottomSameReader;
        private String bottomValue;
        private final int numHits;

        public StringOrdValComparator(int numHits, String field) {
            this.numHits = numHits;
            int initSize = Math.min(1024, numHits);
            this.ords = new int[initSize];
            this.values = new String[initSize];
            this.readerGen = new int[initSize];
            this.field = field;
        }

        public int compare(int slot1, int slot2) {
            if (this.readerGen[slot1] == this.readerGen[slot2]) {
                return this.ords[slot1] - this.ords[slot2];
            }
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        public int compareBottom(int doc) {
            assert (this.bottomSlot != -1);
            if (this.bottomSameReader) {
                return this.bottomOrd - this.order[doc];
            }
            int order = this.order[doc];
            int cmp = this.bottomOrd - order;
            if (cmp != 0) {
                return cmp;
            }
            String val2 = this.lookup[order];
            if (this.bottomValue == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.bottomValue.compareTo(val2);
        }

        public void copy(int slot, int doc) {
            int ord = this.order[doc];
            this.ensureCapacity(slot);
            this.ords[slot] = ord;
            assert (ord >= 0);
            this.values[slot] = this.lookup[ord];
            this.readerGen[slot] = this.currentReaderGen;
        }

        private void ensureCapacity(int slot) {
            if (this.values.length <= slot) {
                int newSize = Math.min(this.numHits, this.values.length * 2);
                if (newSize <= slot) {
                    newSize = slot + 1;
                }
                this.values = Arrays.copyOf(this.values, newSize);
                this.ords = Arrays.copyOf(this.ords, newSize);
                this.readerGen = Arrays.copyOf(this.readerGen, newSize);
            }
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            FieldCache.StringIndex currentReaderValues = FieldCache.DEFAULT.getStringIndex(reader, this.field);
            ++this.currentReaderGen;
            this.order = currentReaderValues.order;
            this.lookup = currentReaderValues.lookup;
            assert (this.lookup.length > 0);
            if (this.bottomSlot != -1) {
                this.setBottom(this.bottomSlot);
            }
        }

        public void setBottom(int bottom) {
            this.bottomSlot = bottom;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                this.ords[this.bottomSlot] = 0;
                this.bottomOrd = 0;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int index = StringOrdValComparator.binarySearch((String[])this.lookup, (String)this.bottomValue);
                if (index < 0) {
                    this.bottomOrd = -index - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = index;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        public Comparable<?> value(int slot) {
            return this.values[slot];
        }

        public String[] getValues() {
            return this.values;
        }

        public int getBottomSlot() {
            return this.bottomSlot;
        }

        public String getField() {
            return this.field;
        }
    }
}

