/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.util;

public class MessagedResult {
    public static final int NORMAL = 0;
    public static final int WARNING = 1;
    public static final int FATAL = 2;
    private int state;
    private String message;
    private boolean result;

    public MessagedResult(boolean result) {
        this.result = result;
        this.state = 0;
    }

    public MessagedResult(boolean result, String message) {
        this.result = result;
        this.message = message;
        if (!result) {
            this.state = 1;
        }
    }

    public MessagedResult(boolean result, String message, int state) {
        this.result = result;
        this.message = message;
        if (!result) {
            if (this.isValidState(state)) {
                this.state = state;
            } else {
                throw new IllegalArgumentException("The provided state: " + state + " is not a valid state.");
            }
        }
    }

    public MessagedResult(String html, int state) {
        this.message = html;
        if (!this.isValidState(state)) {
            throw new IllegalArgumentException("The provided state: " + state + " is not a valid state.");
        }
        this.state = state;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isFatal() {
        return !this.result && this.state == 2;
    }

    public boolean isWarning() {
        return !this.result && this.state == 1;
    }

    private boolean isValidState(int state) {
        return state == 0 || state == 1 || state == 2;
    }
}

