/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.jira.timezone.TimeZoneManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.annotation.concurrent.NotThreadSafe;
import org.jfree.data.time.Hour;
import org.jfree.data.time.TimePeriod;

@NotThreadSafe
public final class TimePeriodUtils {
    private static final String HOUR_PATTERN = "EEE MMM dd HH:mm:ss z yyyy";
    private final DateFormat hourDateFormat;
    private final TimeZoneManager timeZoneManager;

    public TimePeriodUtils(TimeZoneManager timeZoneManager) {
        this.timeZoneManager = timeZoneManager;
        this.hourDateFormat = this.createFormatter(HOUR_PATTERN, timeZoneManager);
    }

    public String prettyPrint(TimePeriod timePeriod) {
        if (timePeriod instanceof Hour) {
            return this.hourDateFormat.format(timePeriod.getStart());
        }
        return String.valueOf(timePeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriodUtils that = (TimePeriodUtils)o;
        return !(this.timeZoneManager == null ? that.timeZoneManager != null : !this.timeZoneManager.equals(that.timeZoneManager));
    }

    public int hashCode() {
        return this.timeZoneManager != null ? this.timeZoneManager.hashCode() : 0;
    }

    private SimpleDateFormat createFormatter(String pattern, TimeZoneManager timeZoneManager) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(timeZoneManager.getLoggedInUserTimeZone());
        return simpleDateFormat;
    }
}

