/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.worklog;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import java.math.BigDecimal;

public interface TimeTrackingConfiguration {
    public boolean enabled();

    public Mode getMode();

    public DateUtils.Duration getDefaultUnit();

    public BigDecimal getHoursPerDay();

    public BigDecimal getDaysPerWeek();

    public boolean copyCommentToWorkDescriptionOnTransition();

    public static class PropertiesAdaptor
    implements TimeTrackingConfiguration {
        public final ApplicationProperties properties;

        public PropertiesAdaptor(ApplicationProperties properties) {
            this.properties = properties;
        }

        @Override
        public boolean enabled() {
            return this.properties.getOption("jira.option.timetracking");
        }

        @Override
        public Mode getMode() {
            return this.properties.getOption("jira.timetracking.estimates.legacy.behaviour") ? Mode.LEGACY : Mode.MODERN;
        }

        @Override
        public DateUtils.Duration getDefaultUnit() {
            DateUtils.Duration defaultUnit;
            try {
                defaultUnit = DateUtils.Duration.valueOf((String)this.properties.getDefaultBackedString("jira.timetracking.default.unit"));
            }
            catch (IllegalArgumentException e) {
                defaultUnit = DateUtils.Duration.MINUTE;
            }
            catch (NullPointerException e) {
                defaultUnit = DateUtils.Duration.MINUTE;
            }
            return defaultUnit;
        }

        @Override
        public BigDecimal getHoursPerDay() {
            return new BigDecimal(this.properties.getDefaultBackedString("jira.timetracking.hours.per.day"));
        }

        @Override
        public BigDecimal getDaysPerWeek() {
            return new BigDecimal(this.properties.getDefaultBackedString("jira.timetracking.days.per.week"));
        }

        @Override
        public boolean copyCommentToWorkDescriptionOnTransition() {
            return this.properties.getOption("jira.timetracking.copy.comment.to.work.desc.on.transition");
        }
    }

    public static enum Mode {
        LEGACY,
        MODERN;

    }
}

