/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jdk.utilities.threaddump;

import com.atlassian.jdk.utilities.JvmProperties;
import com.atlassian.jdk.utilities.threaddump.ThreadDumper;
import org.apache.log4j.Logger;

public class ThreadDumpGenerator {
    private static Logger log = Logger.getLogger(ThreadDumpGenerator.class);

    public static void generateThreadDump() {
        ThreadDumpGenerator.printThreadDump(new ThreadDumper());
    }

    static void printThreadDump(ThreadDumper threadDumper) {
        try {
            if (ThreadDumpGenerator.canGenerateThreadDump()) {
                threadDumper.printThreadDump();
            } else {
                log.warn((Object)"Cannot generate thread dump.");
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error occurred while generating thread dump.", t);
        }
    }

    static boolean canGenerateThreadDump() {
        try {
            return JvmProperties.isJvmVersion(1.5f);
        }
        catch (Exception e) {
            log.warn((Object)("Cannot determine JVM version: " + e.getMessage()));
            return false;
        }
    }
}

