/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.token.ResetPasswordTokenDao;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.model.token.InternalResetPasswordToken;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetPasswordTokenDaoMemory
implements ResetPasswordTokenDao {
    private static final Logger logger = LoggerFactory.getLogger(ResetPasswordTokenDaoMemory.class);
    public static final String CACHE_NAME = InternalResetPasswordToken.class.getName();
    private final CacheManager cacheManager;

    public ResetPasswordTokenDaoMemory(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public InternalResetPasswordToken addToken(InternalResetPasswordToken token) {
        try {
            this.cacheManager.put(CACHE_NAME, (Serializable)((Object)token.getUsername()), (Serializable)token);
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return token;
    }

    @Override
    public InternalResetPasswordToken findTokenByUsername(String username) throws ObjectNotFoundException {
        try {
            return (InternalResetPasswordToken)this.cacheManager.get(CACHE_NAME, (Serializable)((Object)username));
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(InternalResetPasswordToken.class, (Object)username);
        }
    }

    @Override
    public void removeTokenByUsername(String username) {
        this.cacheManager.remove(CACHE_NAME, (Serializable)((Object)username));
    }
}

