/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch;

import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.Percentage;
import com.atlassian.crowd.util.TimedProgressOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchProcessor<S>
implements BatchProcessor<S> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBatchProcessor.class);
    private int batchSize = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends Serializable> BatchResult<E> execute(HibernateOperation<S> op, Collection<E> objects) {
        int numberOfObjects = objects.size();
        int numberOfBatches = numberOfObjects / this.batchSize + (numberOfObjects % this.batchSize > 0 ? 1 : 0);
        logger.debug("processing [ {} ] objects in [ {} ] batches of [ {} ] with [ {} ]", new Object[]{numberOfObjects, numberOfBatches, this.batchSize, op.getClass().getName()});
        BatchResult result = new BatchResult(objects.size());
        TimedProgressOperation operation = new TimedProgressOperation("processed batch", numberOfBatches, logger);
        this.beforeProcessCollection();
        try {
            ArrayList<Serializable> batch = new ArrayList<Serializable>(this.batchSize);
            for (Serializable object : objects) {
                batch.add(object);
                if (batch.size() != this.batchSize) continue;
                this.processBatch(result, op, batch);
                operation.incrementedProgress();
                batch.clear();
            }
            if (!batch.isEmpty()) {
                this.processBatch(result, op, batch);
                batch.clear();
                operation.incrementedProgress();
            }
        }
        finally {
            this.afterProcessCollection();
        }
        return result;
    }

    private <E extends Serializable> void processBatch(BatchResult<E> result, HibernateOperation<S> op, List<E> objects) {
        int count = 0;
        int numberOfObjects = objects.size();
        try {
            this.beforeProcessBatch();
            for (Serializable object : objects) {
                this.performOperation(op, object);
                logger.trace("processed [ {} ] [ {}% ]", new Object[]{object.toString(), Percentage.get((int)count, (int)numberOfObjects)});
            }
            this.afterProcessBatch();
            result.addSuccesses(objects);
        }
        catch (RuntimeException e) {
            logger.warn("batch failed falling back to individual processing", (Throwable)e);
            this.rollbackProcessBatch();
            this.processIndividual(result, op, objects);
        }
    }

    private <E extends Serializable> void processIndividual(BatchResult<E> result, HibernateOperation<S> op, Collection<E> objects) {
        int numberOfObjects = objects.size();
        logger.debug("processing [ {} ] individually", (Object)numberOfObjects);
        int count = 0;
        for (Serializable object : objects) {
            ++count;
            try {
                this.beforeProcessIndividual();
                this.performOperation(op, object);
                logger.debug("processed [ {} ] [ {}% ]", new Object[]{object.toString(), Percentage.get((int)count, (int)numberOfObjects)});
                this.afterProcessIndividual();
                result.addSuccess((Object)object);
            }
            catch (RuntimeException e) {
                this.rollbackProcessIndividual();
                result.addFailure((Object)object);
                logger.error("Could not process " + object.getClass() + ": " + object.toString(), (Throwable)e);
            }
        }
    }

    private void performOperation(HibernateOperation<S> op, Object object) {
        if (object instanceof TransactionGroup) {
            TransactionGroup transactionGroup = (TransactionGroup)object;
            op.performOperation(transactionGroup.getPrimaryObject(), this.getSession());
            for (Object dep : transactionGroup.getDependantObjects()) {
                op.performOperation(dep, this.getSession());
            }
        } else {
            op.performOperation(object, this.getSession());
        }
    }

    protected abstract S getSession();

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected abstract void beforeProcessCollection();

    protected abstract void afterProcessCollection();

    protected abstract void beforeProcessBatch();

    protected abstract void afterProcessBatch();

    protected abstract void rollbackProcessBatch();

    protected abstract void beforeProcessIndividual();

    protected abstract void afterProcessIndividual();

    protected abstract void rollbackProcessIndividual();
}

