/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.group.AutoGroupCreatedEvent;
import com.atlassian.crowd.event.group.AutoGroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.AutoGroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.AutoUserCreatedEvent;
import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAuthenticationDirectory
implements RemoteDirectory {
    private static final Logger logger = LoggerFactory.getLogger(DelegatedAuthenticationDirectory.class);
    public static final String ATTRIBUTE_CREATE_USER_ON_AUTH = "crowd.delegated.directory.auto.create.user";
    public static final String ATTRIBUTE_UPDATE_USER_ON_AUTH = "crowd.delegated.directory.auto.update.user";
    public static final String ATTRIBUTE_LDAP_DIRECTORY_CLASS = "crowd.delegated.directory.type";
    public static final String ATTRIBUTE_KEY_IMPORT_GROUPS = "crowd.delegated.directory.importGroups";
    private final RemoteDirectory ldapDirectory;
    private final RemoteDirectory internalDirectory;
    private final EventPublisher eventPublisher;
    private final DirectoryDao directoryDao;

    public DelegatedAuthenticationDirectory(RemoteDirectory ldapDirectory, RemoteDirectory internalDirectory, EventPublisher eventPublisher, DirectoryDao directoryDao) {
        this.ldapDirectory = ldapDirectory;
        this.internalDirectory = internalDirectory;
        this.eventPublisher = eventPublisher;
        this.directoryDao = directoryDao;
    }

    public long getDirectoryId() {
        return this.internalDirectory.getDirectoryId();
    }

    public void setDirectoryId(long directoryId) {
        throw new UnsupportedOperationException("You cannot mutate the directoryID of " + this.getClass().getName());
    }

    public String getDescriptiveName() {
        return "Delegated Authentication Directory";
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("You cannot mutate the attributes of " + this.getClass().getName());
    }

    public User findUserByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserByName(name);
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserWithAttributesByName(name);
    }

    public User authenticate(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        User user2;
        block14: {
            try {
                user2 = this.findUserByName(name);
                if (user2.isActive()) {
                    try {
                        User ldapUser = this.ldapDirectory.authenticate(name, credential);
                        if (this.isUserUpdateOnAuthEnabled()) {
                            user2 = this.updateLdapUser(ldapUser, user2);
                        }
                        if (this.isImportGroupsEnabled()) {
                            this.updateGroups(ldapUser, user2);
                        }
                        break block14;
                    }
                    catch (InvalidUserException e) {
                        throw new InvalidAuthenticationException("Failed to clone LDAP user <" + name + "> to internal directory", (Throwable)e);
                    }
                    catch (UserNotFoundException e) {
                        throw new InvalidAuthenticationException("Failed to authenticate principal, no credentials in authenticating delegate directory");
                    }
                }
                throw new InactiveAccountException(user2.getName());
            }
            catch (UserNotFoundException e) {
                if (this.isUserCreateOnAuthEnabled()) {
                    User ldapUser = this.ldapDirectory.authenticate(name, credential);
                    try {
                        user2 = this.addLdapUser(ldapUser);
                    }
                    catch (InvalidUserException e1) {
                        throw new InvalidAuthenticationException("Failed to clone LDAP user <" + name + "> to internal directory", (Throwable)e1);
                    }
                    catch (UserAlreadyExistsException e1) {
                        User user2;
                        if (logger.isInfoEnabled()) {
                            logger.info("User " + name + " could not be found initially, but when cloning the user internally, user exists");
                        }
                        if (!(user2 = this.findUserByName(name)).isActive()) {
                            throw new InactiveAccountException(user2.getName());
                        }
                        return user2;
                    }
                }
                throw e;
            }
        }
        return user2;
    }

    public User addOrUpdateLdapUser(String name) throws UserNotFoundException, OperationFailedException {
        User ldapUser = this.ldapDirectory.findUserByName(name);
        try {
            User internalUser = this.internalDirectory.findUserByName(name);
            User updatedUser = this.updateLdapUser(ldapUser, internalUser);
            if (this.isImportGroupsEnabled()) {
                this.updateGroups(ldapUser, internalUser);
            }
            return updatedUser;
        }
        catch (InvalidUserException e) {
            throw new OperationFailedException(name, (Throwable)e);
        }
        catch (UserNotFoundException e) {
            try {
                return this.addLdapUser(ldapUser);
            }
            catch (UserAlreadyExistsException e2) {
                if (logger.isInfoEnabled()) {
                    logger.info("User was added during the internal cloning process. Returning found user.");
                }
                return this.findUserByName(name);
            }
            catch (InvalidUserException e3) {
                throw new OperationFailedException(name, (Throwable)e3);
            }
        }
    }

    private User addLdapUser(User user) throws OperationFailedException, InvalidUserException, UserAlreadyExistsException {
        try {
            User createdUser = this.addUser(new UserTemplate(user), null);
            Directory dir = this.directoryDao.findById(createdUser.getDirectoryId());
            this.eventPublisher.publish((Object)new AutoUserCreatedEvent((Object)this, dir, createdUser));
            if (this.isImportGroupsEnabled()) {
                this.importGroups(user, dir);
            }
            return createdUser;
        }
        catch (InvalidCredentialException e) {
            throw new OperationFailedException("Could not create authenticated user <" + user.getName() + "> " + "in underlying InternalDirectory: " + e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while cloning a user: " + e.getMessage());
        }
    }

    private void importGroups(User user, Directory dir) {
        try {
            this.importGroups(user, dir, this.getGroups(user, this.ldapDirectory, String.class));
        }
        catch (CrowdException exception) {
            logger.error("Could not import remote group memberships of user \"" + user.getName() + "\" in directory \"" + this.getDescriptiveName() + "\".", (Throwable)exception);
        }
    }

    private void importGroups(User user, Directory dir, Iterable<String> groupNames) throws OperationFailedException {
        for (String groupName : groupNames) {
            try {
                InternalDirectoryGroup group = (InternalDirectoryGroup)this.internalDirectory.findGroupByName(groupName);
                if (group.isLocal()) {
                    logger.warn("Remote group \"" + groupName + "\" in directory \"" + this.getDescriptiveName() + "\" is shadowed by a local group of the same name and will not be imported.");
                    continue;
                }
                logger.debug("Remote group \"" + groupName + "\" in directory \"" + this.getDescriptiveName() + "\" has already been imported.");
                this.importMembership(user, groupName, dir);
            }
            catch (GroupNotFoundException exception) {
                try {
                    GroupTemplate groupTemplate = new GroupTemplate(groupName, this.internalDirectory.getDirectoryId());
                    groupTemplate.setLocal(false);
                    Group createdGroup = this.internalDirectory.addGroup(groupTemplate);
                    logger.info("Imported remote group \"" + groupName + "\" to directory \"" + this.getDescriptiveName() + "\".");
                    this.eventPublisher.publish((Object)new AutoGroupCreatedEvent((Object)this, dir, createdGroup));
                    this.importMembership(user, groupName, dir);
                }
                catch (Exception exception2) {
                    logger.error("Could not import remote group \"" + groupName + "\" in directory \"" + this.getDescriptiveName() + "\".", (Throwable)exception2);
                }
            }
        }
    }

    private void importMembership(User user, String groupName, Directory dir) {
        try {
            this.addUserToGroup(user.getName(), groupName);
            logger.info("Imported user \"" + user.getName() + "\"'s membership of remote group \"" + groupName + "\" to directory \"" + this.getDescriptiveName() + "\".");
            this.eventPublisher.publish((Object)new AutoGroupMembershipCreatedEvent((Object)this, dir, user.getName(), groupName, MembershipType.GROUP_USER));
        }
        catch (Exception exception) {
            logger.error("Could not import user \"" + user.getName() + "\"'s membership of remote group \"" + groupName + "\" to directory \"" + this.getDescriptiveName() + "\".", (Throwable)exception);
        }
    }

    private User updateLdapUser(User ldapUser, User internalUser) throws InvalidUserException, OperationFailedException {
        try {
            UserTemplate template = new UserTemplate(ldapUser);
            template.setActive(internalUser.isActive());
            if (!ldapUser.getName().equals(internalUser.getName())) {
                logger.warn("remote username [ {} ] casing differs from local username [ {} ]. User details will be kept updated, but the username cannot be updated", (Object)ldapUser.getName(), (Object)internalUser.getName());
                template.setName(internalUser.getName());
            }
            User updatedUser = this.updateUser(template);
            Directory dir = this.directoryDao.findById(updatedUser.getDirectoryId());
            this.eventPublisher.publish((Object)new AutoUserUpdatedEvent((Object)this, dir, updatedUser));
            return updatedUser;
        }
        catch (UserNotFoundException e) {
            throw new ConcurrentModificationException("User was removed during cloning process: " + e.getMessage());
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while cloning a user: " + e.getMessage());
        }
    }

    private void updateGroups(User ldapUser, User internalUser) {
        try {
            Directory dir = this.directoryDao.findById(ldapUser.getDirectoryId());
            HashSet ldapGroupNames = Sets.newHashSet(this.getGroups(ldapUser, this.ldapDirectory, String.class));
            ImmutableMap internalGroupsMap = Maps.uniqueIndex(this.getGroups(internalUser, this.internalDirectory, Group.class), (Function)new Function<Group, String>(){

                public final String apply(Group group) {
                    return group.getName();
                }
            });
            Set internalGroupNames = internalGroupsMap.keySet();
            for (String groupName : Sets.difference(internalGroupNames, (Set)ldapGroupNames)) {
                if (((InternalDirectoryGroup)internalGroupsMap.get(groupName)).isLocal()) continue;
                try {
                    this.removeUserFromGroup(internalUser.getName(), groupName);
                    this.eventPublisher.publish((Object)new AutoGroupMembershipDeletedEvent((Object)this, dir, internalUser.getName(), groupName, MembershipType.GROUP_USER));
                    logger.info("Deleted user \"" + internalUser.getName() + "\"'s imported membership of remote group \"" + groupName + "\" to directory \"" + this.getDescriptiveName() + "\".");
                }
                catch (Exception exception) {
                    logger.error("Could not delete user \"" + internalUser.getName() + "\"'s imported membership of remote group \"" + groupName + "\" to directory \"" + this.getDescriptiveName() + "\".", (Throwable)exception);
                }
            }
            this.importGroups(internalUser, dir, (Iterable<String>)Sets.difference((Set)ldapGroupNames, internalGroupNames));
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while updating the groups of a user " + e.getMessage());
        }
        catch (Exception exception) {
            logger.error("Could not update remote group imported memberships of user \"" + internalUser.getName() + "\" in directory \"" + this.getDescriptiveName() + "\".", (Throwable)exception);
        }
    }

    private <T> List<T> getGroups(User user, RemoteDirectory directory, Class<T> returnType) throws OperationFailedException {
        return directory.searchGroupRelationships(QueryBuilder.queryFor(returnType, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1));
    }

    public User addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, UserAlreadyExistsException, OperationFailedException {
        return this.internalDirectory.addUser(user, credential);
    }

    public User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        return this.internalDirectory.updateUser(user);
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        throw new OperationNotSupportedException("Passwords are stored in LDAP and are read-only for delegated authentication directory");
    }

    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        return this.internalDirectory.renameUser(oldName, newName);
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.storeUserAttributes(username, attributes);
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.removeUserAttributes(username, attributeName);
    }

    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.removeUser(name);
    }

    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchUsers(query);
    }

    public Group findGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupByName(name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupWithAttributesByName(name);
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        group.setLocal(true);
        return this.internalDirectory.addGroup(group);
    }

    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        return this.internalDirectory.updateGroup(group);
    }

    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException, OperationFailedException {
        return this.internalDirectory.renameGroup(oldName, newName);
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.storeGroupAttributes(groupName, attributes);
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.removeGroupAttributes(groupName, attributeName);
    }

    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.removeGroup(name);
    }

    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroups(query);
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        return this.internalDirectory.isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        return this.internalDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.addUserToGroup(username, groupName);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.removeUserFromGroup(username, groupName);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
    }

    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroupRelationships(query);
    }

    public void testConnection() throws OperationFailedException {
        this.ldapDirectory.testConnection();
    }

    public boolean supportsInactiveAccounts() {
        return this.internalDirectory.supportsInactiveAccounts();
    }

    public boolean supportsNestedGroups() {
        return this.internalDirectory.supportsNestedGroups();
    }

    public boolean isRolesDisabled() {
        return this.internalDirectory.isRolesDisabled();
    }

    public Set<String> getValues(String key) {
        return this.internalDirectory.getValues(key);
    }

    public String getValue(String key) {
        return this.internalDirectory.getValue(key);
    }

    public Set<String> getKeys() {
        return this.internalDirectory.getKeys();
    }

    public boolean isEmpty() {
        return this.internalDirectory.isEmpty();
    }

    public RemoteDirectory getAuthoritativeDirectory() {
        return this.ldapDirectory;
    }

    private boolean isUserCreateOnAuthEnabled() {
        return Boolean.parseBoolean(this.getValue(ATTRIBUTE_CREATE_USER_ON_AUTH));
    }

    private boolean isUserUpdateOnAuthEnabled() {
        return Boolean.parseBoolean(this.getValue(ATTRIBUTE_UPDATE_USER_ON_AUTH));
    }

    private boolean isImportGroupsEnabled() {
        return Boolean.parseBoolean(this.getValue(ATTRIBUTE_KEY_IMPORT_GROUPS));
    }

    public Iterable<Membership> getMemberships() throws OperationFailedException {
        return this.internalDirectory.getMemberships();
    }
}

