/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapPasswordEncoder;
import com.atlassian.security.password.RandomSaltGenerator;
import com.atlassian.security.password.SaltGenerator;
import org.springframework.security.authentication.encoding.LdapShaPasswordEncoder;

public class LdapSshaPasswordEncoder
extends LdapShaPasswordEncoder
implements LdapPasswordEncoder,
InternalPasswordEncoder {
    private static final SaltGenerator DEFAULT_SALT_GENERATOR = new RandomSaltGenerator();
    private final SaltGenerator saltGenerator;

    public LdapSshaPasswordEncoder() {
        this(DEFAULT_SALT_GENERATOR);
    }

    LdapSshaPasswordEncoder(SaltGenerator saltGenerator) {
        this.setForceLowerCasePrefix(false);
        this.saltGenerator = saltGenerator;
    }

    @Override
    public String encodePassword(String rawPass, Object salt) {
        if (salt == null) {
            salt = this.saltGenerator.generateSalt(8);
        }
        return super.encodePassword(rawPass, salt);
    }

    @Override
    public String getKey() {
        return "ssha";
    }
}

