/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.exception.PasswordEncoderException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapPasswordEncoder;
import javax.crypto.Cipher;
import sun.misc.BASE64Encoder;

public class DESPasswordEncoder
implements LdapPasswordEncoder,
InternalPasswordEncoder {
    private PropertyManager propertyManager;
    public static final String PASSWORD_ENCRYPTION_ALGORITHM = "DES";

    @Override
    public String encodePassword(String rawPass, Object salt) {
        try {
            Cipher ecipher = Cipher.getInstance(PASSWORD_ENCRYPTION_ALGORITHM);
            ecipher.init(1, this.propertyManager.getDesEncryptionKey());
            byte[] utf8 = rawPass.getBytes("UTF-8");
            byte[] enc = ecipher.doFinal(utf8);
            return new BASE64Encoder().encode(enc);
        }
        catch (Exception e) {
            throw new PasswordEncoderException("Failed to encrypt password to DES", e);
        }
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        boolean valid = false;
        if (encPass != null) {
            valid = encPass.equals(this.encodePassword(rawPass, salt));
        }
        return valid;
    }

    @Override
    public String getKey() {
        return "des";
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }
}

