/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph.v25;

import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.http.CacheAwareCrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.AuthenticatorUserCache;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.auth.LoginReason;
import com.atlassian.seraph.elevatedsecurity.ElevatedSecurityGuard;
import com.atlassian.seraph.util.RedirectUtils;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrowdAuthenticator
extends DefaultAuthenticator {
    private static final String SESSION_TOKEN_KEY = CrowdAuthenticator.class.getName() + "#SESSION_TOKEN_KEY";
    public static final String PASSWORD_RESET_REQUIRED_HEADER = "X-Seraph-PasswordResetRequired";
    protected static final Logger logger = LoggerFactory.getLogger(CrowdAuthenticator.class);
    private static final String CORRECT_PASSWORD = "c";
    private static final String INCORRECT_PASSWORD = "i";
    private final CrowdHttpAuthenticator crowdHttpAuthenticator;

    public CrowdAuthenticator(CrowdHttpAuthenticator crowdHttpAuthenticator) {
        this.crowdHttpAuthenticator = new CacheAwareCrowdHttpAuthenticator(crowdHttpAuthenticator, new AuthenticatorUserCache(){

            public void fetchInCache(String username) throws UserNotFoundException, InvalidAuthenticationException, OperationFailedException {
                CrowdAuthenticator.this.fetchUserInCache(username);
            }
        });
    }

    protected void fetchUserInCache(String username) throws UserNotFoundException, InvalidAuthenticationException, OperationFailedException {
        this.getUser(username);
    }

    protected boolean authenticate(Principal user, String password) {
        return CORRECT_PASSWORD.equals(password);
    }

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        boolean authenticated;
        try {
            this.logout(request, response);
            request.setAttribute(LoginReason.REQUEST_ATTR_NAME, null);
            logger.debug("Authenticating user with Crowd");
            this.crowdHttpAuthenticator.authenticate(request, response, username, password);
            authenticated = true;
        }
        catch (ExpiredCredentialException ece) {
            logger.info("Credentials have expired or were reset by an administrator", (Throwable)ece);
            authenticated = false;
            response.addHeader(PASSWORD_RESET_REQUIRED_HEADER, "true");
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
            authenticated = false;
        }
        String fakePassword = authenticated ? CORRECT_PASSWORD : INCORRECT_PASSWORD;
        logger.debug("Updating user session for Seraph");
        authenticated = super.login(request, response, username, fakePassword, cookie);
        return authenticated;
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        try {
            logger.debug("Logging off from Crowd");
            this.crowdHttpAuthenticator.logout(request, response);
            logger.debug("Invalidating user in Crowd-Seraph specific session variables");
            this.logoutUser(request);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
        logger.debug("Invalidating user in Seraph specific session variables");
        return super.logout(request, response);
    }

    protected boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        Principal basicAuthUser;
        boolean authenticated = this.isTrustedAppsRequest(request);
        if (!authenticated) {
            try {
                authenticated = this.crowdHttpAuthenticator.isAuthenticated(request, response);
                if (authenticated && logger.isDebugEnabled()) {
                    logger.debug("User IS authenticated via the Crowd session-token");
                } else if (logger.isDebugEnabled()) {
                    logger.debug("User is NOT authenticated via the Crowd session-token");
                }
            }
            catch (Exception e) {
                logger.info("Error while attempting to check if user isAuthenticated with Crowd", (Throwable)e);
            }
        }
        if (!authenticated) {
            authenticated = this.rememberMeLoginToCrowd(request, response);
            if (authenticated && logger.isDebugEnabled()) {
                logger.debug("Authenticated via remember-me cookie");
            } else if (logger.isDebugEnabled()) {
                logger.debug("Failed to authenticate via remember-me cookie");
            }
        }
        if (!authenticated && RedirectUtils.isBasicAuthentication((HttpServletRequest)request, (String)this.getAuthType()) && (basicAuthUser = this.getUserFromBasicAuthentication(request, response)) != null) {
            authenticated = true;
        }
        if (!authenticated) {
            if (request.getSession(false) != null) {
                logger.debug("Request is not authenticated, logging out the user");
                try {
                    this.logoutUser(request);
                    if (response != null) {
                        super.logout(request, response);
                    }
                }
                catch (AuthenticatorException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                logger.debug("Request is not authenticated and has no session.");
            }
            authenticated = false;
        }
        return authenticated;
    }

    protected boolean rememberMeLoginToCrowd(HttpServletRequest request, HttpServletResponse response) {
        Principal cookieUser = this.getUserFromCookie(request, response);
        if (cookieUser == null) {
            return false;
        }
        logger.debug("User successfully authenticated via remember-me cookie verification");
        try {
            this.crowdHttpAuthenticator.authenticateWithoutValidatingPassword(request, response, cookieUser.getName());
            return true;
        }
        catch (Exception e) {
            logger.debug("Could not register remember-me cookie authenticated user with Crowd SSO: " + cookieUser.getName() + ", reason: " + e.getMessage(), (Throwable)e);
            this.removePrincipalFromSessionContext(request);
            return false;
        }
    }

    protected abstract void logoutUser(HttpServletRequest var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        ElevatedSecurityGuard securityGuard = this.getElevatedSecurityGuard();
        Principal user = null;
        if (this.isTrustedAppsRequest(request)) {
            return this.getUserFromSession(request);
        }
        if (!this.isAuthenticated(request, response)) return user;
        String cookieToken = this.crowdHttpAuthenticator.getToken(request);
        if (cookieToken == null) {
            logger.error("Could not find cookieToken from authenticated request");
            return null;
        }
        Object sessionToken = request.getSession().getAttribute(SESSION_TOKEN_KEY);
        if (cookieToken.equals(sessionToken)) {
            user = this.getUserFromSession(request);
        }
        if (user == null) {
            try {
                User crowdUser = this.crowdHttpAuthenticator.getUser(request);
                user = this.getUser(crowdUser.getName());
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
            if (user == null) return user;
            if (!this.authoriseUserAndEstablishSession(request, response, user)) return null;
            LoginReason.OK.stampRequestResponse(request, response);
            securityGuard.onSuccessfulLoginAttempt(request, user.getName());
            request.getSession().setAttribute(SESSION_TOKEN_KEY, (Object)cookieToken);
            return user;
        }
        LoginReason.OK.stampRequestResponse(request, response);
        return user;
    }

    private boolean isTrustedAppsRequest(HttpServletRequest request) {
        if ("success".equals(request.getAttribute("os_authstatus"))) {
            if (logger.isDebugEnabled()) {
                logger.debug("User IS authenticated via previous filter/trusted apps");
            }
            return true;
        }
        return false;
    }
}

