/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.bootstrap;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.spring.BootstrappedContainerContext;
import com.atlassian.config.spring.BootstrappedContextLoader;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.spring.container.ContainerContextLoaderListener;
import com.atlassian.spring.container.SpringContainerContext;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.springframework.web.context.ContextLoader;

public class BootstrappedContextLoaderListener
extends ContainerContextLoaderListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(BootstrappedContextLoaderListener.class);

    public boolean canInitialiseContainer() {
        AtlassianBootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        if (bootstrapManager == null) {
            return false;
        }
        if (!bootstrapManager.isBootstrapped()) {
            return false;
        }
        boolean hibernateSetup = bootstrapManager.getHibernateConfig().isHibernateSetup();
        if (!hibernateSetup && BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            log.error((Object)"Hibernate not yet setup, but setup complete - can't initalise container - corrupt project.cfg.xml?");
        }
        return hibernateSetup;
    }

    protected SpringContainerContext getNewSpringContainerContext() {
        return new BootstrappedContainerContext();
    }

    public ContextLoader createContextLoader() {
        return new BootstrappedContextLoader();
    }
}

