/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.impl.CacheEntryListenerSupport;
import com.atlassian.cache.impl.DefaultCacheEntryListenerSupport;
import com.atlassian.cache.memory.DelegatingCacheStatistics;
import com.atlassian.cache.memory.ManagedCacheSupport;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class DelegatingCache<K, V>
extends ManagedCacheSupport
implements Cache<K, V> {
    private final com.google.common.cache.Cache<K, V> internalCache;
    private final CacheEntryListenerSupport<K, V> listenerSupport;

    private DelegatingCache(com.google.common.cache.Cache<K, V> internalCache, String name, CacheSettings settings) {
        super(name, settings);
        this.internalCache = internalCache;
        this.listenerSupport = new DefaultCacheEntryListenerSupport();
    }

    static <K, V> DelegatingCache<K, V> create(LoadingCache<K, V> internalCache, String name, CacheSettings settings) {
        return new DelegatingLoadingCache(internalCache, name, settings);
    }

    static <K, V> DelegatingCache<K, V> create(com.google.common.cache.Cache<K, V> internalCache, String name, CacheSettings settings) {
        return new DelegatingCache<K, V>(internalCache, name, settings);
    }

    public boolean containsKey(@Nonnull K key) {
        return null != this.internalCache.getIfPresent(key);
    }

    @Nonnull
    public Collection<K> getKeys() {
        try {
            return this.internalCache.asMap().keySet();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(@Nonnull K key, @Nonnull V value) {
        try {
            V oldValue = this.internalCache.asMap().put(key, value);
            if (oldValue == null) {
                this.listenerSupport.notifyAdd(key, value);
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V get(@Nonnull K key) {
        return (V)this.internalCache.getIfPresent(key);
    }

    public void remove(@Nonnull K key) {
        try {
            this.internalCache.invalidate(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void removeAll() {
        try {
            this.internalCache.invalidateAll();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        try {
            V oldValue = this.internalCache.asMap().putIfAbsent(key, value);
            if (oldValue == null) {
                this.listenerSupport.notifyAdd(key, value);
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean remove(@Nonnull K key, @Nonnull V value) {
        try {
            return this.internalCache.asMap().remove(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean replace(@Nonnull K key, @Nonnull V oldValue, @Nonnull V newValue) {
        try {
            return this.internalCache.asMap().replace(key, oldValue, newValue);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Nonnull
    public SortedMap<CacheStatisticsKey, Supplier<Long>> getStatistics() {
        return DelegatingCacheStatistics.toStatistics(this.internalCache);
    }

    public void clear() {
        this.removeAll();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof DelegatingCache) {
            DelegatingCache otherDelegatingCache = (DelegatingCache)other;
            if (this.internalCache.equals(otherDelegatingCache.internalCache)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }

    public void addListener(@Nonnull CacheEntryListener<K, V> listener, boolean includeValues) {
        this.listenerSupport.add(listener, includeValues);
    }

    public void removeListener(@Nonnull CacheEntryListener<K, V> listener) {
        this.listenerSupport.remove(listener);
    }

    private static class DelegatingLoadingCache<K, V>
    extends DelegatingCache<K, V> {
        private final LoadingCache<K, V> internalCache;

        private DelegatingLoadingCache(LoadingCache<K, V> internalCache, String name, CacheSettings settings) {
            super((com.google.common.cache.Cache)internalCache, name, settings);
            this.internalCache = internalCache;
        }

        @Override
        public V get(@Nonnull K key) {
            try {
                return (V)this.internalCache.get(key);
            }
            catch (UncheckedExecutionException e) {
                Throwable cause = e.getCause();
                Throwables.propagateIfInstanceOf((Throwable)cause, CacheException.class);
                throw new CacheException(cause);
            }
            catch (Exception e) {
                Throwables.propagateIfInstanceOf((Throwable)e, CacheException.class);
                throw new CacheException((Throwable)e);
            }
        }
    }

    protected static class DelegatingRemovalListener<K, V>
    implements RemovalListener<K, V> {
        private DelegatingCache<K, V> cache;

        protected DelegatingRemovalListener() {
        }

        protected void onSupply(K key, V value) {
            ((DelegatingCache)this.cache).listenerSupport.notifyAdd(key, value);
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
            switch (notification.getCause()) {
                case COLLECTED: 
                case EXPIRED: {
                    ((DelegatingCache)this.cache).listenerSupport.notifyEvict(notification.getKey(), notification.getValue());
                    break;
                }
                case EXPLICIT: {
                    ((DelegatingCache)this.cache).listenerSupport.notifyRemove(notification.getKey(), notification.getValue());
                    break;
                }
                case REPLACED: {
                    Object key = notification.getKey();
                    ((DelegatingCache)this.cache).listenerSupport.notifyUpdate(key, ((DelegatingCache)this.cache).internalCache.getIfPresent(key), notification.getValue());
                }
            }
        }

        public void setCache(DelegatingCache<K, V> cache) {
            this.cache = cache;
        }
    }
}

