/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheBuilder;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.LazyReference;
import com.atlassian.cache.LazyReferenceBuilder;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.memory.MemoryCacheBuilder;
import com.atlassian.cache.memory.MemoryLazyReferenceBuilder;
import com.atlassian.cache.memory.ReferenceKey;
import com.atlassian.util.concurrent.NotNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCacheManager
implements CacheManager {
    private final ConcurrentMap<String, CacheHolder<?, ?>> caches = new ConcurrentHashMap();

    public Collection<ManagedCache> getCaches() {
        HashSet<ManagedCache> ret = new HashSet<ManagedCache>();
        for (CacheHolder cacheHolder : this.caches.values()) {
            ret.add(cacheHolder.get());
        }
        return ret;
    }

    public void flushCaches() {
        for (CacheHolder cacheHolder : this.caches.values()) {
            ManagedCache cache = cacheHolder.get();
            if (cache.isFlushable()) continue;
            cache.clear();
        }
    }

    public <K, V> CacheBuilder<K, V> newCacheBuilder(@NotNull String name) {
        return new MemoryCacheBuilder(name, this);
    }

    public <V> LazyReferenceBuilder<V> newLazyReferenceBuilder(@NotNull String name) {
        return new MemoryLazyReferenceBuilder(name, this);
    }

    public <K, V> Cache<K, V> getCache(@NotNull String name) {
        return this.getCache(new MemoryCacheBuilder(name, this));
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) {
        return this.getCache(name);
    }

    <K, V> Cache<K, V> getCache(CacheBuilder<K, V> builder) {
        MemoryCacheBuilder myBuilder = (MemoryCacheBuilder)builder;
        String name = myBuilder.getName();
        if (!this.caches.containsKey(name)) {
            this.caches.putIfAbsent(name, new SimpleCacheHolder(name, myBuilder));
        }
        return (Cache)((CacheHolder)this.caches.get(name)).get();
    }

    <V> LazyReference<V> getLazyReference(LazyReferenceBuilder<V> builder) {
        MemoryLazyReferenceBuilder myBuilder = (MemoryLazyReferenceBuilder)builder;
        String name = myBuilder.getName();
        if (!this.caches.containsKey(name)) {
            this.caches.putIfAbsent(name, new LazyRefHolder(name, myBuilder));
        }
        return (LazyReference)((CacheHolder)this.caches.get(name)).get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LazyRefHolder<V>
    extends com.atlassian.util.concurrent.LazyReference<LazyReference<V>>
    implements CacheHolder<ReferenceKey, V> {
        private final String name;
        private final MemoryLazyReferenceBuilder<V> builder;

        public LazyRefHolder(String name, MemoryLazyReferenceBuilder<V> builder) {
            this.name = name;
            this.builder = builder;
        }

        protected LazyReference<V> create() throws Exception {
            return this.builder.createLazyReference(this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SimpleCacheHolder<K, V>
    extends com.atlassian.util.concurrent.LazyReference<Cache<K, V>>
    implements CacheHolder<K, V> {
        private final String name;
        private final MemoryCacheBuilder<K, V> builder;

        public SimpleCacheHolder(String name, MemoryCacheBuilder<K, V> builder) {
            this.name = name;
            this.builder = builder;
        }

        protected Cache<K, V> create() throws Exception {
            return this.builder.createCache();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface CacheHolder<K, V> {
        public ManagedCache get();

        public String getName();
    }
}

