/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCacheManager
implements CacheManager {
    protected final ConcurrentMap<String, com.atlassian.util.concurrent.Supplier<ManagedCache>> caches = new ConcurrentHashMap<String, com.atlassian.util.concurrent.Supplier<ManagedCache>>();
    protected final Function<String, ManagedLock> cacheCreationLocks = ManagedLocks.weakManagedLockFactory();
    protected final CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider;

    protected AbstractCacheManager(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        this.cacheSettingsDefaultsProvider = cacheSettingsDefaultsProvider;
    }

    @Nonnull
    public Collection<Cache<?, ?>> getCaches() {
        ArrayList managedCaches = new ArrayList(64);
        for (com.atlassian.util.concurrent.Supplier cacheRef : this.caches.values()) {
            ManagedCache managedCache = (ManagedCache)cacheRef.get();
            if (!(managedCache instanceof Cache)) continue;
            managedCaches.add((Cache)managedCache);
        }
        return managedCaches;
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        ArrayList<ManagedCache> managedCaches = new ArrayList<ManagedCache>(64);
        for (com.atlassian.util.concurrent.Supplier cacheRef : this.caches.values()) {
            ManagedCache managedCache = (ManagedCache)cacheRef.get();
            if (managedCache == null) continue;
            managedCaches.add(managedCache);
        }
        return managedCaches;
    }

    @Nullable
    public ManagedCache getManagedCache(@Nonnull String name) {
        com.atlassian.util.concurrent.Supplier cacheRef = (com.atlassian.util.concurrent.Supplier)this.caches.get(name);
        return null == cacheRef ? null : (ManagedCache)cacheRef.get();
    }

    public void flushCaches() {
        for (com.atlassian.util.concurrent.Supplier cacheRef : this.caches.values()) {
            ManagedCache managedCache = (ManagedCache)cacheRef.get();
            if (managedCache == null || !managedCache.isFlushable()) continue;
            managedCache.clear();
        }
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name) {
        return this.getCache(name, null);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull Class<?> owningClass, @Nonnull String name) {
        return this.getCache(AbstractCacheManager.cacheName(owningClass, name));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        return this.getCache(name);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, CacheLoader<K, V> loader) {
        return this.getCache(name, loader, new CacheSettingsBuilder().build());
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.getCachedReference(name, supplier, new CacheSettingsBuilder().build());
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.getCachedReference(owningClass, name, supplier, new CacheSettingsBuilder().build());
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings settings) {
        return this.getCachedReference(AbstractCacheManager.cacheName(owningClass, name), supplier, settings);
    }

    private static String cacheName(Class<?> owningClass, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return owningClass.getName() + '.' + name;
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, CacheLoader<K, V> loader, @Nonnull CacheSettings settings) {
        if (null == loader) {
            return (Cache)this.createSimpleCache(name, this.mergeSettings(name, settings));
        }
        return (Cache)this.createComputingCache(name, this.mergeSettings(name, settings), loader);
    }

    protected abstract <K, V> ManagedCache createComputingCache(@Nonnull String var1, @Nonnull CacheSettings var2, CacheLoader<K, V> var3);

    protected abstract ManagedCache createSimpleCache(@Nonnull String var1, @Nonnull CacheSettings var2);

    protected CacheSettings mergeSettings(String name, CacheSettings settings) {
        if (this.cacheSettingsDefaultsProvider == null) {
            return settings;
        }
        return this.cacheSettingsDefaultsProvider.getDefaults(name).override(settings);
    }

    public void shutdown() {
    }
}

