/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.BrowserConfiguration;
import com.atlassian.browsers.BrowserInstaller;
import com.atlassian.browsers.BuiltInConfigurator;
import com.atlassian.browsers.InstallConfigurator;
import com.atlassian.browsers.XvfbManager;
import java.io.File;
import org.apache.commons.lang.Validate;

public class BrowserAutoInstaller {
    private static boolean useXvfb = Boolean.parseBoolean(System.getProperty("xvfb.enable", "false"));
    private XvfbManager xvfbManager;
    private BrowserConfiguration browserConfiguration;
    private BuiltInConfigurator installConfigurator;

    public BrowserAutoInstaller(BrowserConfiguration browserConfiguration, InstallConfigurator configurator) {
        Validate.notNull((Object)browserConfiguration, (String)"Browser Configuration can not be null.");
        Validate.notNull((Object)configurator, (String)"The Install configurator cannot be null.");
        this.browserConfiguration = browserConfiguration;
        this.installConfigurator = new BuiltInConfigurator(configurator);
    }

    public void setupBrowser() {
        BrowserInstaller browserInstaller;
        String display;
        File tmpDir = this.browserConfiguration.getTmpDir().getAbsoluteFile();
        tmpDir.mkdirs();
        this.createXvfbManager(tmpDir);
        if (this.xvfbManager != null && XvfbManager.isSupportedOS() && (display = this.xvfbManager.getDisplay()) != null) {
            System.setProperty("DISPLAY", display);
        }
        if ((browserInstaller = BrowserInstaller.typeOf(this.browserConfiguration.getBrowserName())) != null) {
            browserInstaller.install(tmpDir, this.installConfigurator);
        }
    }

    private void createXvfbManager(File tmpDir) {
        if (useXvfb && XvfbManager.isSupportedOS()) {
            final XvfbManager xvfb = new XvfbManager(tmpDir);
            xvfb.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    xvfb.stop();
                }
            });
            this.xvfbManager = xvfb;
        }
    }
}

