/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.router.schema;

import android.util.Log;
import com.antfortune.freeline.FreelineCore;
import com.antfortune.freeline.router.ISchemaAction;
import com.antfortune.freeline.server.EmbedHttpServer;
import com.antfortune.freeline.server.LongLinkServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class PushDexSchema
implements ISchemaAction {
    private static final String TAG = "Freeline.PushDex";

    @Override
    public String getDescription() {
        return "pushDex";
    }

    @Override
    public void handle(String method, String path, HashMap<String, String> headers, Map<String, String> queries, InputStream input, EmbedHttpServer.ResponseOutputStream response) throws Exception {
        int l;
        String dexName = queries.get("dexName");
        File dexDir = new File(FreelineCore.getDynamicDexDir());
        File file = new File(dexDir, dexName + ".pending");
        File dir = new File(FreelineCore.getDynamicInfoTempDir());
        File optDir = new File(dir, "opt");
        if (!optDir.exists()) {
            optDir.mkdirs();
        }
        String vmVersion = System.getProperty("java.vm.version");
        File finalFile = null;
        finalFile = vmVersion != null && vmVersion.startsWith("2") ? new File(dexDir, dexName + ".apk") : new File(dexDir, dexName + ".dex");
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buf = new byte[4096];
        while ((l = input.read(buf)) != -1) {
            fos.write(buf, 0, l);
        }
        fos.close();
        LongLinkServer.markDexChanged();
        response.setStatusCode(201);
        boolean rst = file.renameTo(finalFile);
        LongLinkServer.setDynamicDexPath(dexDir.getAbsolutePath());
        LongLinkServer.setOptDirPath(optDir.getAbsolutePath());
        Log.d((String)TAG, (String)("dex file received (" + finalFile.length() + " bytes), rename result :" + rst + ", save to " + finalFile.getAbsolutePath()));
    }
}

