/*
 * Decompiled with CFR 0.152.
 */
package com.antfortune.freeline.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.Method;
import java.util.List;

public class AppUtils {
    private static final String TAG = "Freeline.AppUtils";

    public static boolean isApkDebugable(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getCurProcessName(Context context) {
        String strRet = null;
        try {
            Class<?> clazz = Class.forName("android.ddm.DdmHandleAppName");
            Method method = clazz.getDeclaredMethod("getAppName", new Class[0]);
            strRet = (String)method.invoke(clazz, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        if (TextUtils.isEmpty(strRet)) {
            int pid = Process.myPid();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List runningAppProcesses = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo appProcess : runningAppProcesses) {
                if (appProcess.pid != pid) continue;
                strRet = appProcess.processName;
                break;
            }
        }
        return strRet;
    }

    public static boolean isMainProcess(Context context) {
        String packageName = context.getPackageName();
        String processName = AppUtils.getCurProcessName(context);
        return packageName.equalsIgnoreCase(processName);
    }

    public static boolean isFreelineProcess(Context context) {
        String processName = AppUtils.getCurProcessName(context);
        return processName.endsWith(":freeline");
    }

    public static String findJniLibrary(Context context, String libName) {
        String result = null;
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader != null) {
            try {
                Object objPath;
                Method findLibraryMethod = classLoader.getClass().getMethod("findLibrary", String.class);
                if (findLibraryMethod != null && (objPath = findLibraryMethod.invoke((Object)classLoader, libName)) != null && objPath instanceof String) {
                    result = (String)objPath;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
        return result;
    }
}

