/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.opentelemetry.api.internal;

import com.aliyun.openservices.shade.com.google.auto.value.AutoValue;
import com.aliyun.openservices.shade.io.opentelemetry.api.internal.AutoValue_ImmutableSpanContext;
import com.aliyun.openservices.shade.io.opentelemetry.api.trace.SpanContext;
import com.aliyun.openservices.shade.io.opentelemetry.api.trace.SpanId;
import com.aliyun.openservices.shade.io.opentelemetry.api.trace.TraceFlags;
import com.aliyun.openservices.shade.io.opentelemetry.api.trace.TraceId;
import com.aliyun.openservices.shade.io.opentelemetry.api.trace.TraceState;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableSpanContext
implements SpanContext {
    public static final SpanContext INVALID = ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), TraceFlags.getDefault(), TraceState.getDefault(), false, false);

    private static AutoValue_ImmutableSpanContext createInternal(String traceId, String spanId, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean valid) {
        return new AutoValue_ImmutableSpanContext(traceId, spanId, traceFlags, traceState, remote, valid);
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean skipIdValidation) {
        if (skipIdValidation || SpanId.isValid(spanIdHex) && TraceId.isValid(traceIdHex)) {
            return ImmutableSpanContext.createInternal(traceIdHex, spanIdHex, traceFlags, traceState, remote, true);
        }
        return ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), traceFlags, traceState, remote, false);
    }

    @Override
    public abstract boolean isValid();
}

