/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HistoryNode implements Serializable, Comparable<HistoryNode> {
    /**
     * History node endpoint, in form of IP:port
     */
    private String endpoint;

    /**
     * The timestamp when keep-alive ping is received.
     */
    private volatile long keepAliveTimestamp = System.currentTimeMillis();

    /**
     * Labels of the history-node, including deployment network information.
     */
    private Map<String, String> labels = new HashMap<String, String>();

    @Override
    public int compareTo(HistoryNode other) {
        return endpoint.compareTo(other.endpoint);
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public long getKeepAliveTimestamp() {
        return keepAliveTimestamp;
    }

    public void setKeepAliveTimestamp(long keepAliveTimestamp) {
        this.keepAliveTimestamp = keepAliveTimestamp;
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public boolean accept(Map<String, String> filter) {
        if (null == filter || filter.isEmpty()) {
            return true;
        }

        if (null == labels || labels.isEmpty()) {
            return false;
        }

        for (Map.Entry<String, String> entry : filter.entrySet()) {
            if (!labels.containsKey(entry.getKey())) {
                return false;
            }

            if (!labels.get(entry.getKey()).equals(entry.getValue())) {
                return false;
            }
        }

        return true;
    }
}
