package com.aliyun.openservices.ons.api.impl;

import com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.ons.api.*;
import com.aliyun.openservices.ons.api.impl.rocketmq.*;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;

import java.util.Properties;


public class ONSFactoryImpl implements ONSFactoryAPI {
    @Override
    public Producer createProducer(final Properties properties) {
        ProducerImpl producer = new ProducerImpl(properties);
        return producer;
    }


    @Override
    public Consumer createConsumer(final Properties properties) {
        ConsumerImpl consumer = new ConsumerImpl(properties);
        return consumer;
    }


    @Override
    public OrderProducer createOrderProducer(final Properties properties) {
        OrderProducerImpl producer = new OrderProducerImpl(properties);
        return producer;
    }


    @Override
    public OrderConsumer createOrderedConsumer(final Properties properties) {
        OrderConsumerImpl consumer = new OrderConsumerImpl(properties);
        return consumer;
    }


    @Override
    public TransactionProducer createTransactionProducer(Properties properties,
                                                         final LocalTransactionChecker checker) {
        TransactionProducerImpl transactionProducer = new TransactionProducerImpl(properties, new TransactionCheckListener() {
            @Override
            public LocalTransactionState checkLocalTransactionState(MessageExt msg) {
                String msgId = msg.getProperty(Constants.TRANSACTION_ID);
                Message message = ONSUtil.msgConvert(msg);
                message.setMsgID(msgId);
                TransactionStatus check = checker.check(message);
                if (TransactionStatus.CommitTransaction == check) {
                    return LocalTransactionState.COMMIT_MESSAGE;
                } else if (TransactionStatus.RollbackTransaction == check) {
                    return LocalTransactionState.ROLLBACK_MESSAGE;
                }
                return LocalTransactionState.UNKNOW;
            }
        });
        return transactionProducer;
    }
}
