package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.ons.api.Constants;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;


public class TransactionProducerImpl extends ONSClientAbstract implements TransactionProducer {
    TransactionMQProducer transactionMQProducer = null;
    private Properties properties;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public TransactionProducerImpl(Properties properties, TransactionCheckListener transactionCheckListener) {
        super(properties);
        this.properties = properties;
        transactionMQProducer = new TransactionMQProducer((String) properties.get(PropertyKeyConst.ProducerId), new ClientRPCHook(sessionCredentials));
        transactionMQProducer.setTransactionCheckListener(transactionCheckListener);
    }


    @Override
    public void start() {
        if (started.compareAndSet(false, true)) {
            if (transactionMQProducer.getTransactionCheckListener() == null) {
                throw new IllegalArgumentException("TransactionCheckListener is null");
            }
            //TODO 完善寻址功能。要实现TransactionMQProducer.sendMessageInTransaction
            transactionMQProducer.setNamesrvAddr(this.nameServerAddr);
            try {
                transactionMQProducer.start();
            } catch (MQClientException e) {
                throw new RuntimeException(e);
            }
        }
    }


    @Override
    public void shutdown() {
        if (closed.compareAndSet(false, true)) {
            transactionMQProducer.shutdown();
        }
    }


    @Override
    public SendResult send(final Message message, final LocalTransactionExecuter executer, Object arg) {
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        MessageAccessor.putProperty(msgRMQ, PropertyKeyConst.ProducerId, (String) properties.get(PropertyKeyConst.ProducerId));
        com.alibaba.rocketmq.client.producer.SendResult sendResultRMQ = null;
        try {
            sendResultRMQ = transactionMQProducer.sendMessageInTransaction(msgRMQ, new com.alibaba.rocketmq.client.producer.LocalTransactionExecuter() {
                @Override
                public LocalTransactionState executeLocalTransactionBranch(com.alibaba.rocketmq.common.message.Message msg, Object arg) {
                    String msgId = msg.getProperty(Constants.TRANSACTION_ID);
                    message.setMsgID(msgId);
                    TransactionStatus transactionStatus = executer.execute(message, arg);
                    if (TransactionStatus.CommitTransaction == transactionStatus) {
                        return LocalTransactionState.COMMIT_MESSAGE;
                    } else if (TransactionStatus.RollbackTransaction == transactionStatus) {
                        return LocalTransactionState.ROLLBACK_MESSAGE;
                    }
                    return LocalTransactionState.UNKNOW;
                }
            }, arg);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        SendResult sendResult = new SendResult();
        sendResult.setMessageId(sendResultRMQ.getMsgId());
        if (sendResultRMQ.getTransactionId() != null) {
            sendResult.setMessageId(sendResultRMQ.getTransactionId());
            //sendResult.setTransactionId(sendResultRMQ.getTransactionId());
        }
        return sendResult;
    }

    @Override
    public boolean isStarted() {
        return started.get();
    }

    @Override
    public boolean isClosed() {
        return closed.get();
    }
}
