package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.rocketmq.remoting.CommandCustomHeader;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.ons.api.impl.authority.AuthUtil;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;

import java.lang.reflect.Field;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

import static com.aliyun.openservices.ons.api.impl.authority.SessionCredentials.*;


/**
 * @auther lansheng.zj
 */
public class ClientRPCHook implements RPCHook {

    private SessionCredentials sessionCredentials;
    private ConcurrentHashMap<Class<? extends CommandCustomHeader>, Field[]> fieldCache;


    public ClientRPCHook(SessionCredentials sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
        fieldCache = new ConcurrentHashMap<Class<? extends CommandCustomHeader>, Field[]>();
    }


    @Override
    public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
        CommandCustomHeader header = request.readCustomHeader();
        // sort property
        SortedMap<String, String> map = new TreeMap<String, String>();
        map.put(AccessKey, sessionCredentials.getAccessKey());
        map.put(ONSChannelKey, sessionCredentials.getOnsChannel().toString());
        try {
            // add header properties
            if (null != header) {
                Field[] fields = fieldCache.get(header.getClass());
                if (null == fields) {
                    fields = header.getClass().getDeclaredFields();
                    for (Field field : fields) {
                        field.setAccessible(true);
                    }
                    Field[] tmp = fieldCache.putIfAbsent(header.getClass(), fields);
                    if (null != tmp) {
                        fields = tmp;
                    }
                }

                for (Field field : fields) {
                    Object value = field.get(header);
                    if (null != value) {
                        map.put(field.getName(), value.toString());
                    }
                }
            }
            byte[] total = AuthUtil.combineRequestContent(request, map);
            String signature = AuthUtil.calSignature(total, sessionCredentials.getSecretKey());
            request.addExtField(Signature, signature);
            request.addExtField(AccessKey, sessionCredentials.getAccessKey());
            request.addExtField(ONSChannelKey, sessionCredentials.getOnsChannel().toString());
        }
        catch (Exception e) {
            throw new RuntimeException("incompatible exception.", e);
        }
    }


    @Override
    public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {

    }

}
