/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(NamedThreadFactory.class);
    private static final String DEFAULT_NAME = "canal-worker";
    private final String name;
    private final boolean daemon;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    static final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (t, e) -> {
        if (e instanceof InterruptedException || e.getCause() != null && e.getCause() instanceof InterruptedException) {
            return;
        }
        logger.error("from " + t.getName(), e);
    };

    public NamedThreadFactory() {
        this(DEFAULT_NAME, true);
    }

    public NamedThreadFactory(String name) {
        this(name, true);
    }

    public NamedThreadFactory(String name, boolean daemon) {
        this.name = name;
        this.daemon = daemon;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.name + "-" + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.daemon);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        return t;
    }
}

