/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;
import java.util.Map;

public class HiveOutputVisitor
extends SQLASTOutputVisitor
implements HiveASTVisitor {
    public HiveOutputVisitor(Appendable appender) {
        super(appender);
    }

    public HiveOutputVisitor(Appendable appender, String dbType) {
        super(appender, dbType);
    }

    public HiveOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(HiveCreateTableStatement x) {
        this.printCreateTable(x, true);
        return false;
    }

    protected void printCreateTable(HiveCreateTableStatement x, boolean printSelect) {
        Map<String, SQLObject> tableOptions;
        SQLName storedAs;
        int buckets;
        List<SQLSelectOrderByItem> sortedBy;
        SQLExternalRecordFormat format;
        List<SQLSelectOrderByItem> clusteredBy;
        int partitionSize;
        SQLExpr comment;
        this.print0(this.ucase ? "CREATE " : "create ");
        SQLCreateTableStatement.Type tableType = x.getType();
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)tableType)) {
            this.print0(this.ucase ? "GLOBAL TEMPORARY " : "global temporary ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)tableType)) {
            this.print0(this.ucase ? "LOCAL TEMPORARY " : "local temporary ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExiists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getName());
        this.printTableElements(x.getTableElementList());
        SQLExprTableSource inherits = x.getInherits();
        if (inherits != null) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            inherits.accept(this);
            this.print(')');
        }
        if ((comment = x.getComment()) != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY (" : "partitioned by (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(column.getAfterCommentsDirect());
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((clusteredBy = x.getClusteredBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "CLUSTERED BY (" : "clustered by (");
            this.printAndAccept(clusteredBy, ",");
            this.print(')');
        }
        if ((format = x.getRowFormat()) != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT DELIMITED " : "row format delimited ");
            this.visit(format);
        }
        if ((sortedBy = x.getSortedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SORTED BY (" : "sorted by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
        }
        if ((buckets = x.getBuckets()) > 0) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.print(buckets);
            this.print0(this.ucase ? " BUCKETS" : " buckets");
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.println();
            this.print0(this.ucase ? "STORE AS " : "store as ");
            this.printExpr(storedAs);
        }
        if ((tableOptions = x.getTableOptions()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            int i = 0;
            for (Map.Entry<String, SQLObject> option : tableOptions.entrySet()) {
                this.print0(option.getKey());
                this.print0(" = ");
                option.getValue().accept(this);
                ++i;
            }
            this.print(')');
        }
        SQLSelect select = x.getSelect();
        if (printSelect && select != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            this.visit(select);
        }
    }

    @Override
    public void endVisit(HiveCreateTableStatement x) {
    }

    @Override
    public boolean visit(SQLExternalRecordFormat x) {
        if (x.getDelimitedBy() != null) {
            this.println();
            this.print0(this.ucase ? "LINES TERMINATED BY " : "lines terminated by ");
            x.getDelimitedBy().accept(this);
        }
        if (x.getTerminatedBy() != null) {
            this.println();
            this.print0(this.ucase ? "FIELDS TERMINATED BY " : "fields terminated by ");
            x.getTerminatedBy().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(HiveMultiInsertStatement x) {
    }

    @Override
    public boolean visit(HiveMultiInsertStatement x) {
        SQLTableSource from = x.getFrom();
        if (x.getFrom() != null) {
            if (from instanceof SQLSubqueryTableSource) {
                SQLSelect select = ((SQLSubqueryTableSource)from).getSelect();
                this.print0(this.ucase ? "FROM (" : "from (");
                ++this.indentCount;
                this.println();
                select.accept(this);
                --this.indentCount;
                this.println();
                this.print0(") ");
                this.print0(x.getFrom().getAlias());
            } else {
                this.print0(this.ucase ? "FROM " : "from ");
                from.accept(this);
            }
            this.println();
        }
        for (int i = 0; i < x.getItems().size(); ++i) {
            HiveInsert insert = x.getItems().get(i);
            if (i != 0) {
                this.println();
            }
            insert.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(HiveInsertStatement x) {
    }

    @Override
    public boolean visit(HiveInsertStatement x) {
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        int partitions = x.getPartitions().size();
        if (partitions > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitions; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = x.getPartitions().get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print('=');
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(HiveInsert x) {
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        int partitions = x.getPartitions().size();
        if (partitions > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitions; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = x.getPartitions().get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print('=');
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public void endVisit(HiveInsert x) {
    }
}

