/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaObjectImpl;
import com.alibaba.druid.sql.repository.SchemaObjectType;
import com.alibaba.druid.sql.repository.SchemaRepository;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class Schema {
    private String name;
    protected final Map<String, SchemaObject> objects = new ConcurrentSkipListMap<String, SchemaObject>();
    private final Map<String, SchemaObject> functions = new ConcurrentSkipListMap<String, SchemaObject>();
    private final SchemaVisitor visitor = new SchemaVisitor();
    private SchemaRepository repository;

    public Schema(SchemaRepository repository) {
        this.repository = repository;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SchemaObject findTable(String tableName) {
        String lowerName = tableName.toLowerCase();
        SchemaObject object = this.objects.get(lowerName);
        if (object != null && object.getType() == SchemaObjectType.Table) {
            return object;
        }
        return null;
    }

    public SchemaObject findTableOrView(String tableName) {
        String lowerName = tableName.toLowerCase();
        SchemaObject object = this.objects.get(lowerName);
        if (object == null) {
            return null;
        }
        SchemaObjectType type = object.getType();
        if (type == SchemaObjectType.Table || type == SchemaObjectType.View) {
            return object;
        }
        return null;
    }

    public SchemaObject findFunction(String functionName) {
        String lowerName = functionName.toLowerCase();
        return this.functions.get(lowerName);
    }

    public void acceptDDL(String ddl, String dbType) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddl, dbType);
        for (SQLStatement stmt : stmtList) {
            this.accept(stmt);
        }
    }

    public void accept(SQLStatement stmt) {
        stmt.accept(this.visitor);
    }

    public boolean isSequence(String name) {
        SchemaObject object = this.objects.get(name);
        return object != null && object.getType() == SchemaObjectType.Sequence;
    }

    public SchemaObject findTable(SQLTableSource tableSource, String alias) {
        if (tableSource instanceof SQLExprTableSource) {
            if (alias.equalsIgnoreCase(tableSource.computeAlias())) {
                SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
                SchemaObject tableObject = exprTableSource.getSchemaObject();
                if (tableObject != null) {
                    return tableObject;
                }
                SQLExpr expr = exprTableSource.getExpr();
                if (expr instanceof SQLIdentifierExpr) {
                    String tableName = ((SQLIdentifierExpr)expr).getName();
                    tableObject = this.findTable(tableName);
                    if (tableObject != null) {
                        exprTableSource.setSchemaObject(tableObject);
                    }
                    return tableObject;
                }
                if (expr instanceof SQLPropertyExpr) {
                    String tableName = ((SQLPropertyExpr)expr).getName();
                    tableObject = this.findTable(tableName);
                    if (tableObject != null) {
                        exprTableSource.setSchemaObject(tableObject);
                    }
                    return tableObject;
                }
            }
            return null;
        }
        if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            SQLTableSource left = join.getLeft();
            SchemaObject tableObject = this.findTable(left, alias);
            if (tableObject != null) {
                return tableObject;
            }
            SQLTableSource right = join.getRight();
            tableObject = this.findTable(right, alias);
            return tableObject;
        }
        return null;
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLSelectItem selectItem) {
        if (selectItem == null) {
            return null;
        }
        return this.findColumn(tableSource, selectItem.getExpr());
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLExpr expr) {
        SchemaObject object = this.findTable(tableSource, expr);
        if (object != null) {
            SQLAggregateExpr aggregateExpr;
            String function;
            if (expr instanceof SQLAggregateExpr && ("min".equalsIgnoreCase(function = (aggregateExpr = (SQLAggregateExpr)expr).getMethodName()) || "max".equalsIgnoreCase(function))) {
                SQLExpr arg;
                expr = arg = aggregateExpr.getArguments().get(0);
            }
            if (expr instanceof SQLName) {
                return object.findColumn(((SQLName)expr).getSimpleName());
            }
        }
        return null;
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLSelectItem selectItem) {
        if (selectItem == null) {
            return null;
        }
        return this.findTable(tableSource, selectItem.getExpr());
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLExpr expr) {
        SQLAggregateExpr aggregateExpr;
        String function;
        if (expr instanceof SQLAggregateExpr && ("min".equalsIgnoreCase(function = (aggregateExpr = (SQLAggregateExpr)expr).getMethodName()) || "max".equalsIgnoreCase(function))) {
            SQLExpr arg = aggregateExpr.getArguments().get(0);
            return this.findTable(tableSource, arg);
        }
        if (expr instanceof SQLPropertyExpr) {
            String ownerName = ((SQLPropertyExpr)expr).getOwnernName();
            return this.findTable(tableSource, ownerName);
        }
        if (expr instanceof SQLAllColumnExpr || expr instanceof SQLIdentifierExpr) {
            if (tableSource instanceof SQLExprTableSource) {
                return this.findTable(tableSource, tableSource.computeAlias());
            }
            if (tableSource instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
                SchemaObject table = this.findTable(join.getLeft(), expr);
                if (table == null) {
                    table = this.findTable(join.getRight(), expr);
                }
                return table;
            }
            return null;
        }
        return null;
    }

    public Map<String, SchemaObject> getTables(SQLTableSource x) {
        LinkedHashMap<String, SchemaObject> tables = new LinkedHashMap<String, SchemaObject>();
        this.computeTables(x, tables);
        return tables;
    }

    protected void computeTables(SQLTableSource x, Map<String, SchemaObject> tables) {
        if (x == null) {
            return;
        }
        if (x instanceof SQLExprTableSource) {
            SQLExprTableSource exprTableSource = (SQLExprTableSource)x;
            SQLExpr expr = exprTableSource.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                String tableName = ((SQLIdentifierExpr)expr).getName();
                SchemaObject table = exprTableSource.getSchemaObject();
                if (table == null && (table = this.findTable(tableName)) != null) {
                    exprTableSource.setSchemaObject(table);
                }
                if (table != null) {
                    tables.put(tableName, table);
                    String alias = x.getAlias();
                    if (alias != null && !alias.equalsIgnoreCase(tableName)) {
                        tables.put(alias, table);
                    }
                }
            }
            return;
        }
        if (x instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)x;
            this.computeTables(join.getLeft(), tables);
            this.computeTables(join.getRight(), tables);
        }
    }

    public int getTableCount() {
        int count = 0;
        for (SchemaObject object : this.objects.values()) {
            if (object.getType() != SchemaObjectType.Table) continue;
            ++count;
        }
        return count;
    }

    public Map<String, SchemaObject> getObjects() {
        return this.objects;
    }

    public int getViewCount() {
        int count = 0;
        for (SchemaObject object : this.objects.values()) {
            if (object.getType() != SchemaObjectType.View) continue;
            ++count;
        }
        return count;
    }

    public class SchemaVisitor
    extends OracleASTVisitorAdapter {
        @Override
        public boolean visit(SQLDropSequenceStatement x) {
            String name = x.getName().getSimpleName();
            Schema.this.objects.remove(name);
            return false;
        }

        @Override
        public boolean visit(SQLCreateSequenceStatement x) {
            String name = x.getName().getSimpleName();
            SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.Sequence);
            Schema.this.objects.put(name.toLowerCase(), object);
            return false;
        }

        @Override
        public boolean visit(OracleCreateTableStatement x) {
            this.visit((SQLCreateTableStatement)x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            String name = x.computeName();
            SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.Table, x);
            String name_lower = name.toLowerCase();
            if (Schema.this.objects.containsKey(name_lower)) {
                return false;
            }
            Schema.this.objects.put(name_lower, object);
            return false;
        }

        @Override
        public boolean visit(SQLCreateViewStatement x) {
            String name = x.computeName();
            SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.View, x);
            String name_lower = name.toLowerCase();
            if (Schema.this.objects.containsKey(name_lower)) {
                return false;
            }
            Schema.this.objects.put(name_lower, object);
            return false;
        }

        @Override
        public boolean visit(SQLCreateIndexStatement x) {
            String name = x.getName().getSimpleName();
            SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.Index);
            Schema.this.objects.put(name.toLowerCase(), object);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            String name = x.getName().getSimpleName();
            SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.Function, x);
            Schema.this.functions.put(name.toLowerCase(), object);
            return false;
        }
    }
}

