/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SymbolTable;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Lexer {
    protected static SymbolTable symbols_l2 = new SymbolTable(512);
    protected int features = 0;
    public final String text;
    protected int pos;
    protected int mark;
    protected char ch;
    protected char[] buf;
    protected int bufPos;
    protected Token token;
    protected Keywords keywods = Keywords.DEFAULT_KEYWORDS;
    protected String stringVal;
    protected long hash_lower;
    protected long hash;
    protected int commentCount = 0;
    protected List<String> comments = null;
    protected boolean skipComment = true;
    private SavePoint savePoint = null;
    private boolean allowComment = true;
    private int varIndex = -1;
    protected CommentHandler commentHandler;
    protected boolean endOfComment = false;
    protected boolean keepComments = false;
    protected int line = 0;
    protected int lines = 0;
    protected String dbType;
    protected boolean optimizedForParameterized = false;
    private int startPos;
    private int posLine;
    private int posColumn;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int[] digits = new int[58];

    public Lexer(String input) {
        this(input, null);
    }

    public Lexer(String input, CommentHandler commentHandler) {
        this(input, true);
        this.commentHandler = commentHandler;
    }

    public Lexer(String input, CommentHandler commentHandler, String dbType) {
        this(input, true);
        this.commentHandler = commentHandler;
        this.dbType = dbType;
        if ("sqlite".equals(dbType)) {
            this.keywods = Keywords.SQLITE_KEYWORDS;
        }
    }

    public boolean isKeepComments() {
        return this.keepComments;
    }

    public void setKeepComments(boolean keepComments) {
        this.keepComments = keepComments;
    }

    public CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    public void setCommentHandler(CommentHandler commentHandler) {
        this.commentHandler = commentHandler;
    }

    public final char charAt(int index) {
        if (index >= this.text.length()) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    public final String addSymbol() {
        return this.subString(this.mark, this.bufPos);
    }

    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    public final char[] sub_chars(int offset, int count) {
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return chars;
    }

    protected void initBuff(int size) {
        if (this.buf == null) {
            this.buf = size < 32 ? new char[32] : new char[size + 32];
        } else if (this.buf.length < size) {
            this.buf = Arrays.copyOf(this.buf, size);
        }
    }

    public void arraycopy(int srcPos, char[] dest, int destPos, int length) {
        this.text.getChars(srcPos, srcPos + length, dest, destPos);
    }

    public boolean isAllowComment() {
        return this.allowComment;
    }

    public void setAllowComment(boolean allowComment) {
        this.allowComment = allowComment;
    }

    public int nextVarIndex() {
        return ++this.varIndex;
    }

    public Keywords getKeywods() {
        return this.keywods;
    }

    public SavePoint mark() {
        SavePoint savePoint = new SavePoint();
        savePoint.bp = this.pos;
        savePoint.sp = this.bufPos;
        savePoint.np = this.mark;
        savePoint.ch = this.ch;
        savePoint.token = this.token;
        savePoint.stringVal = this.stringVal;
        savePoint.hash = this.hash;
        savePoint.hash_lower = this.hash_lower;
        this.savePoint = savePoint;
        return this.savePoint;
    }

    public void reset(SavePoint savePoint) {
        this.pos = savePoint.bp;
        this.bufPos = savePoint.sp;
        this.mark = savePoint.np;
        this.ch = savePoint.ch;
        this.token = savePoint.token;
        this.stringVal = savePoint.stringVal;
        this.hash = savePoint.hash;
        this.hash_lower = savePoint.hash_lower;
    }

    public void reset() {
        this.reset(this.savePoint);
    }

    public void reset(int pos) {
        this.pos = pos;
        this.ch = this.charAt(pos);
    }

    public Lexer(String input, boolean skipComment) {
        this.skipComment = skipComment;
        this.text = input;
        this.pos = 0;
        this.ch = this.charAt(this.pos);
    }

    public Lexer(char[] input, int inputLength, boolean skipComment) {
        this(new String(input, 0, inputLength), skipComment);
    }

    protected final void scanChar() {
        this.ch = this.charAt(++this.pos);
    }

    protected void unscan() {
        this.ch = this.charAt(--this.pos);
    }

    public boolean isEOF() {
        return this.pos >= this.text.length();
    }

    protected void lexError(String key, Object ... args) {
        this.token = Token.ERROR;
    }

    public final Token token() {
        return this.token;
    }

    public final String getDbType() {
        return this.dbType;
    }

    public String info() {
        int line = 1;
        int column = 1;
        int i = 0;
        while (i < this.startPos) {
            char ch = this.text.charAt(i);
            if (ch == '\n') {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        this.posLine = line;
        this.posColumn = this.posColumn;
        StringBuilder buf = new StringBuilder();
        buf.append("pos ").append(this.pos).append(", line ").append(line).append(", column ").append(column).append(", token ").append((Object)this.token);
        if (this.token == Token.IDENTIFIER || this.token == Token.LITERAL_ALIAS || this.token == Token.LITERAL_CHARS) {
            buf.append(" ").append(this.stringVal);
        }
        return buf.toString();
    }

    public final void nextTokenComma() {
        char ch_next_2;
        char ch_next;
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == ',' || this.ch == '\uff0c') {
            this.scanChar();
            this.token = Token.COMMA;
            return;
        }
        if (this.ch == ')' || this.ch == '\uff09') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        if (this.ch == '.') {
            this.scanChar();
            this.token = Token.DOT;
            return;
        }
        if (!(this.ch != 'a' && this.ch != 'A' || (ch_next = this.charAt(this.pos + 1)) != 's' && ch_next != 'S' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.AS;
            this.stringVal = "AS";
            return;
        }
        this.nextToken();
    }

    public final void nextTokenCommaValue() {
        char ch_next_2;
        char ch_next;
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == ',' || this.ch == '\uff0c') {
            this.scanChar();
            this.token = Token.COMMA;
            return;
        }
        if (this.ch == ')' || this.ch == '\uff09') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        if (this.ch == '.') {
            this.scanChar();
            this.token = Token.DOT;
            return;
        }
        if (!(this.ch != 'a' && this.ch != 'A' || (ch_next = this.charAt(this.pos + 1)) != 's' && ch_next != 'S' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.AS;
            this.stringVal = "AS";
            return;
        }
        this.nextTokenValue();
    }

    public final void nextTokenEq() {
        char ch_next_2;
        char ch_next;
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == '=') {
            this.scanChar();
            this.token = Token.EQ;
            return;
        }
        if (this.ch == '.') {
            this.scanChar();
            this.token = Token.DOT;
            return;
        }
        if (!(this.ch != 'a' && this.ch != 'A' || (ch_next = this.charAt(this.pos + 1)) != 's' && ch_next != 'S' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.AS;
            this.stringVal = "AS";
            return;
        }
        this.nextToken();
    }

    public final void nextTokenLParen() {
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == '(' || this.ch == '\uff08') {
            this.scanChar();
            this.token = Token.LPAREN;
            return;
        }
        this.nextToken();
    }

    public final void nextTokenValue() {
        this.startPos = this.pos;
        if (this.ch == ' ') {
            this.scanChar();
        }
        if (this.ch == '\'') {
            this.bufPos = 0;
            this.scanString();
            return;
        }
        if (this.ch == '\"') {
            this.bufPos = 0;
            this.scanString2_d();
            return;
        }
        if (this.ch == '0') {
            this.bufPos = 0;
            if (this.charAt(this.pos + 1) == 'x') {
                this.scanChar();
                this.scanChar();
                this.scanHexaDecimal();
            } else {
                this.scanNumber();
            }
            return;
        }
        if (this.ch > '0' && this.ch <= '9') {
            this.bufPos = 0;
            this.scanNumber();
            return;
        }
        if (this.ch == '?') {
            this.scanChar();
            this.token = Token.QUES;
            return;
        }
        if (this.ch == 'n' || this.ch == 'N') {
            int c1 = 0;
            if (this.pos + 4 < this.text.length()) {
                char c4;
                char c3;
                char c2;
                char c = this.text.charAt(this.pos + 1);
                c1 = c;
                if (!(c != 'u' && c1 != 85 || (c2 = this.text.charAt(this.pos + 2)) != 'l' && c2 != 'L' || (c3 = this.text.charAt(this.pos + 3)) != 'l' && c3 != 'L' || !CharTypes.isWhitespace(c4 = this.text.charAt(this.pos + 4)) && c4 != ',' && c4 != ')')) {
                    this.pos += 4;
                    this.ch = c4;
                    this.token = Token.NULL;
                    this.stringVal = "NULL";
                    return;
                }
            }
            if (c1 == 39) {
                this.bufPos = 0;
                ++this.pos;
                this.ch = (char)39;
                this.scanString();
                this.token = Token.LITERAL_NCHARS;
                return;
            }
        }
        if (this.ch == ')') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        if (CharTypes.isFirstIdentifierChar(this.ch)) {
            this.scanIdentifier();
            return;
        }
        this.nextToken();
    }

    public final void nextTokenBy() {
        char ch_next_2;
        char ch_next;
        while (this.ch == ' ') {
            this.scanChar();
        }
        if (!(this.ch != 'b' && this.ch != 'B' || (ch_next = this.charAt(this.pos + 1)) != 'y' && ch_next != 'Y' || (ch_next_2 = this.charAt(this.pos + 2)) != ' ')) {
            this.pos += 2;
            this.ch = (char)32;
            this.token = Token.BY;
            this.stringVal = "BY";
            return;
        }
        this.nextToken();
    }

    public final void nextTokenNotOrNull() {
        while (this.ch == ' ') {
            this.scanChar();
        }
        if ((this.ch == 'n' || this.ch == 'N') && this.pos + 3 < this.text.length()) {
            char c4;
            char c1 = this.text.charAt(this.pos + 1);
            char c2 = this.text.charAt(this.pos + 2);
            char c3 = this.text.charAt(this.pos + 3);
            if (!(c1 != 'o' && c1 != 'O' || c2 != 't' && c2 != 'T' || !CharTypes.isWhitespace(c3))) {
                this.pos += 3;
                this.ch = c3;
                this.token = Token.NOT;
                this.stringVal = "NOT";
                return;
            }
            if (!(this.pos + 4 >= this.text.length() || c1 != 'u' && c1 != 'U' || c2 != 'l' && c2 != 'L' || c3 != 'l' && c3 != 'L' || !CharTypes.isWhitespace(c4 = this.text.charAt(this.pos + 4)))) {
                this.pos += 4;
                this.ch = c4;
                this.token = Token.NULL;
                this.stringVal = "NULL";
                return;
            }
        }
        this.nextToken();
    }

    public final void nextTokenIdent() {
        while (this.ch == ' ') {
            this.scanChar();
        }
        if (CharTypes.isFirstIdentifierChar(this.ch)) {
            this.scanIdentifier();
            return;
        }
        if (this.ch == ')') {
            this.scanChar();
            this.token = Token.RPAREN;
            return;
        }
        this.nextToken();
    }

    public final void nextToken() {
        this.startPos = this.pos;
        this.bufPos = 0;
        if (this.comments != null && this.comments.size() > 0) {
            this.comments = null;
        }
        this.lines = 0;
        int startLine = this.line;
        block23: while (true) {
            if (CharTypes.isWhitespace(this.ch)) {
                if (this.ch == '\n') {
                    ++this.line;
                    this.lines = this.line - startLine;
                }
                this.ch = this.charAt(++this.pos);
                continue;
            }
            if (this.ch == '$' && this.charAt(this.pos + 1) == '{') {
                this.scanVariable();
                return;
            }
            if (CharTypes.isFirstIdentifierChar(this.ch)) {
                if (this.ch == '\uff08') {
                    this.scanChar();
                    this.token = Token.LPAREN;
                    return;
                }
                if (this.ch == '\uff09') {
                    this.scanChar();
                    this.token = Token.RPAREN;
                    return;
                }
                if ((this.ch == 'N' || this.ch == 'n') && this.charAt(this.pos + 1) == '\'') {
                    ++this.pos;
                    this.ch = (char)39;
                    this.scanString();
                    this.token = Token.LITERAL_NCHARS;
                    return;
                }
                this.scanIdentifier();
                return;
            }
            switch (this.ch) {
                case '0': {
                    if (this.charAt(this.pos + 1) == 'x') {
                        this.scanChar();
                        this.scanChar();
                        this.scanHexaDecimal();
                    } else {
                        this.scanNumber();
                    }
                    return;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanNumber();
                    return;
                }
                case ',': 
                case '\uff0c': {
                    this.scanChar();
                    this.token = Token.COMMA;
                    return;
                }
                case '(': 
                case '\uff08': {
                    this.scanChar();
                    this.token = Token.LPAREN;
                    return;
                }
                case ')': 
                case '\uff09': {
                    this.scanChar();
                    this.token = Token.RPAREN;
                    return;
                }
                case '[': {
                    this.scanLBracket();
                    return;
                }
                case ']': {
                    this.scanChar();
                    this.token = Token.RBRACKET;
                    return;
                }
                case '{': {
                    this.scanChar();
                    this.token = Token.LBRACE;
                    return;
                }
                case '}': {
                    this.scanChar();
                    this.token = Token.RBRACE;
                    return;
                }
                case ':': {
                    this.scanChar();
                    if (this.ch == '=') {
                        this.scanChar();
                        this.token = Token.COLONEQ;
                    } else if (this.ch == ':') {
                        this.scanChar();
                        this.token = Token.COLONCOLON;
                    } else {
                        this.unscan();
                        this.scanVariable();
                    }
                    return;
                }
                case '#': {
                    this.scanSharp();
                    if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                        this.bufPos = 0;
                        continue block23;
                    }
                    return;
                }
                case '.': {
                    this.scanChar();
                    if (this.isDigit(this.ch) && !CharTypes.isFirstIdentifierChar(this.charAt(this.pos - 2))) {
                        this.unscan();
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '.') {
                        this.scanChar();
                        if (this.ch == '.') {
                            this.scanChar();
                            this.token = Token.DOTDOTDOT;
                        } else {
                            this.token = Token.DOTDOT;
                        }
                    } else {
                        this.token = Token.DOT;
                    }
                    return;
                }
                case '\'': {
                    this.scanString();
                    return;
                }
                case '\"': {
                    this.scanAlias();
                    return;
                }
                case '*': {
                    this.scanChar();
                    this.token = Token.STAR;
                    return;
                }
                case '?': {
                    this.scanChar();
                    if (this.ch == '?' && "postgresql".equals(this.dbType)) {
                        this.scanChar();
                        if (this.ch == '|') {
                            this.scanChar();
                            this.token = Token.QUESBAR;
                        } else {
                            this.token = Token.QUESQUES;
                        }
                    } else if (this.ch == '|' && "postgresql".equals(this.dbType)) {
                        this.scanChar();
                        if (this.ch == '|') {
                            this.unscan();
                            this.token = Token.QUES;
                        } else {
                            this.token = Token.QUESBAR;
                        }
                    } else if (this.ch == '&' && "postgresql".equals(this.dbType)) {
                        this.scanChar();
                        this.token = Token.QUESAMP;
                    } else {
                        this.token = Token.QUES;
                    }
                    return;
                }
                case ';': {
                    this.scanChar();
                    this.token = Token.SEMI;
                    return;
                }
                case '`': {
                    throw new ParserException("TODO. " + this.info());
                }
                case '@': {
                    this.scanVariable_at();
                    return;
                }
                case '-': {
                    if (this.charAt(this.pos + 1) == '-') {
                        this.scanComment();
                        if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block23;
                        }
                    } else {
                        this.scanOperator();
                    }
                    return;
                }
                case '/': {
                    char nextChar = this.charAt(this.pos + 1);
                    if (nextChar == '/' || nextChar == '*') {
                        this.scanComment();
                        if ((this.token == Token.LINE_COMMENT || this.token == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block23;
                        }
                    } else {
                        this.token = Token.SLASH;
                        this.scanChar();
                    }
                    return;
                }
            }
            break;
        }
        if (Character.isLetter(this.ch)) {
            this.scanIdentifier();
            return;
        }
        if (this.isOperator(this.ch)) {
            this.scanOperator();
            return;
        }
        if (this.ch == '\\' && this.charAt(this.pos + 1) == 'N' && "mysql".equals(this.dbType)) {
            this.scanChar();
            this.scanChar();
            this.token = Token.NULL;
            return;
        }
        if (this.isEOF()) {
            this.token = Token.EOF;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.scanChar();
        }
    }

    protected void scanLBracket() {
        this.scanChar();
        this.token = Token.LBRACKET;
    }

    private final void scanOperator() {
        switch (this.ch) {
            case '+': {
                this.scanChar();
                this.token = Token.PLUS;
                break;
            }
            case '-': {
                this.scanChar();
                if (this.ch == '>') {
                    this.scanChar();
                    if (this.ch == '>') {
                        this.scanChar();
                        this.token = Token.SUBGTGT;
                        break;
                    }
                    this.token = Token.SUBGT;
                    break;
                }
                this.token = Token.SUB;
                break;
            }
            case '*': {
                this.scanChar();
                this.token = Token.STAR;
                break;
            }
            case '/': {
                this.scanChar();
                this.token = Token.SLASH;
                break;
            }
            case '&': {
                this.scanChar();
                if (this.ch == '&') {
                    this.scanChar();
                    this.token = Token.AMPAMP;
                    break;
                }
                this.token = Token.AMP;
                break;
            }
            case '|': {
                this.scanChar();
                if (this.ch == '|') {
                    this.scanChar();
                    if (this.ch == '/') {
                        this.scanChar();
                        this.token = Token.BARBARSLASH;
                        break;
                    }
                    this.token = Token.BARBAR;
                    break;
                }
                if (this.ch == '/') {
                    this.scanChar();
                    this.token = Token.BARSLASH;
                    break;
                }
                this.token = Token.BAR;
                break;
            }
            case '^': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.CARETEQ;
                    break;
                }
                this.token = Token.CARET;
                break;
            }
            case '%': {
                this.scanChar();
                this.token = Token.PERCENT;
                break;
            }
            case '=': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.EQEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.EQGT;
                    break;
                }
                this.token = Token.EQ;
                break;
            }
            case '>': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.GTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.GTGT;
                    break;
                }
                this.token = Token.GT;
                break;
            }
            case '<': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    if (this.ch == '>') {
                        this.token = Token.LTEQGT;
                        this.scanChar();
                        break;
                    }
                    this.token = Token.LTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.LTGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.LTLT;
                    break;
                }
                if (this.ch == '@') {
                    this.scanChar();
                    this.token = Token.LT_MONKEYS_AT;
                    break;
                }
                if (this.ch == '-' && this.charAt(this.pos + 1) == '>') {
                    this.scanChar();
                    this.scanChar();
                    this.token = Token.LT_SUB_GT;
                    break;
                }
                if (this.ch == ' ') {
                    char c1 = this.charAt(this.pos + 1);
                    if (c1 == '=') {
                        this.scanChar();
                        this.scanChar();
                        if (this.ch == '>') {
                            this.token = Token.LTEQGT;
                            this.scanChar();
                            break;
                        }
                        this.token = Token.LTEQ;
                        break;
                    }
                    if (c1 == '>') {
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LTGT;
                        break;
                    }
                    if (c1 == '<') {
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LTLT;
                        break;
                    }
                    if (c1 == '@') {
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LT_MONKEYS_AT;
                        break;
                    }
                    if (c1 == '-' && this.charAt(this.pos + 2) == '>') {
                        this.scanChar();
                        this.scanChar();
                        this.scanChar();
                        this.token = Token.LT_SUB_GT;
                        break;
                    }
                    this.token = Token.LT;
                    break;
                }
                this.token = Token.LT;
                break;
            }
            case '!': {
                this.scanChar();
                while (CharTypes.isWhitespace(this.ch)) {
                    this.scanChar();
                }
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.BANGEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.BANGGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.BANGLT;
                    break;
                }
                if (this.ch == '!') {
                    this.scanChar();
                    this.token = Token.BANGBANG;
                    break;
                }
                if (this.ch == '~') {
                    this.scanChar();
                    if (this.ch == '*') {
                        this.scanChar();
                        this.token = Token.BANG_TILDE_STAR;
                        break;
                    }
                    this.token = Token.BANG_TILDE;
                    break;
                }
                this.token = Token.BANG;
                break;
            }
            case '?': {
                this.scanChar();
                this.token = Token.QUES;
                break;
            }
            case '~': {
                this.scanChar();
                if (this.ch == '*') {
                    this.scanChar();
                    this.token = Token.TILDE_STAR;
                    break;
                }
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.TILDE_EQ;
                    break;
                }
                this.token = Token.TILDE;
                break;
            }
            default: {
                throw new ParserException("TODO. " + this.info());
            }
        }
    }

    protected void scanString() {
        this.mark = this.pos;
        boolean hasSpecial = false;
        Token preToken = this.token;
        while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? (preToken == Token.AS ? this.subString(this.mark, this.bufPos + 2) : this.subString(this.mark + 1, this.bufPos)) : new String(this.buf, 0, this.bufPos);
    }

    protected final void scanString2() {
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\'') continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.token == Token.AS ? this.subString(this.pos, endIndex + 1 - this.pos) : this.subString(startIndex, endIndex - startIndex);
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        block14: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block14;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block14;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block14;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block14;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block14;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block14;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block14;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block14;
                    }
                    case '_': {
                        if ("mysql".equals(this.dbType)) {
                            this.putChar('\\');
                        }
                        this.putChar('_');
                        continue block14;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block14;
                    }
                    case '%': {
                        this.putChar('\\');
                        this.putChar(this.ch);
                        continue block14;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }

    protected final void scanString2_d() {
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\"') continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.token == Token.AS ? this.subString(this.pos, endIndex + 1 - this.pos) : this.subString(startIndex, endIndex - startIndex);
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        block14: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block14;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block14;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block14;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block14;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block14;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block14;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block14;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block14;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block14;
                    }
                    case '%': {
                        if ("mysql".equals(this.dbType)) {
                            this.putChar('\\');
                        }
                        this.putChar('%');
                        continue block14;
                    }
                    case '_': {
                        if ("mysql".equals(this.dbType)) {
                            this.putChar('\\');
                        }
                        this.putChar('_');
                        continue block14;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\"') {
                this.scanChar();
                if (this.ch != '\"') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\"');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }

    protected final void scanAlias() {
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch_last;
            char ch_next;
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\"') continue;
            if (i + 1 < this.text.length() && ((ch_next = this.charAt(i + 1)) == '\"' || ch_next == '\'')) {
                hasSpecial = true;
                ++i;
                continue;
            }
            if (i > 0 && (ch_last = this.charAt(i - 1)) == '\'') {
                hasSpecial = true;
                continue;
            }
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.subString(this.pos, endIndex + 1 - this.pos);
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_ALIAS;
                return;
            }
        }
        this.mark = this.pos;
        this.initBuff(this.bufPos);
        block12: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                switch (this.ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block12;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block12;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block12;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\"') {
                char ch_next = this.charAt(this.pos + 1);
                if (ch_next == '\"' || ch_next == '\'') {
                    this.scanChar();
                    continue;
                }
                break;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.scanChar();
        this.token = Token.LITERAL_CHARS;
        this.stringVal = new String(this.buf, 0, this.bufPos);
    }

    public void scanSharp() {
        this.scanVariable();
    }

    public void scanVariable() {
        char ch;
        if (this.ch != ':' && this.ch != '#' && this.ch != '$') {
            throw new ParserException("illegal variable. " + this.info());
        }
        this.mark = this.pos;
        this.bufPos = 1;
        char c1 = this.charAt(this.pos + 1);
        if (c1 == '>' && "postgresql".equalsIgnoreCase(this.dbType)) {
            this.pos += 2;
            this.token = Token.MONKEYS_AT_GT;
            this.ch = this.charAt(++this.pos);
            return;
        }
        if (c1 == '{') {
            char ch2;
            ++this.pos;
            ++this.bufPos;
            while ((ch2 = this.charAt(++this.pos)) != '}') {
                ++this.bufPos;
            }
            if (ch2 != '}') {
                throw new ParserException("syntax error. " + this.info());
            }
            ++this.pos;
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
            this.stringVal = this.addSymbol();
            this.token = Token.VARIANT;
            return;
        }
        while (CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        this.token = Token.VARIANT;
    }

    protected void scanVariable_at() {
        char ch;
        if (this.ch != '@') {
            throw new ParserException("illegal variable. " + this.info());
        }
        this.mark = this.pos;
        this.bufPos = 1;
        char c1 = this.charAt(this.pos + 1);
        if (c1 == '@') {
            ++this.pos;
            ++this.bufPos;
        }
        while (CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        this.token = Token.VARIANT;
    }

    public void scanComment() {
        if (!this.allowComment) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' && this.charAt(this.pos + 1) == '/' || this.ch == '-' && this.charAt(this.pos + 1) == '-') {
            this.scanSingleLineComment();
        } else if (this.ch == '/' && this.charAt(this.pos + 1) == '*') {
            this.scanMultiLineComment();
        } else {
            throw new IllegalStateException();
        }
    }

    private void scanMultiLineComment() {
        Token lastToken = this.token;
        this.scanChar();
        this.scanChar();
        this.mark = this.pos;
        this.bufPos = 0;
        while (true) {
            if (this.ch == '*' && this.charAt(this.pos + 1) == '/') break;
            if (this.ch == '\u001a') {
                throw new ParserException("unterminated /* comment. " + this.info());
            }
            this.scanChar();
            ++this.bufPos;
        }
        this.scanChar();
        this.scanChar();
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.MULTI_LINE_COMMENT;
        ++this.commentCount;
        if (this.keepComments) {
            this.addComment(this.stringVal);
        }
        if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
            return;
        }
        if (!this.isAllowComment() && !this.isSafeComment(this.stringVal)) {
            throw new NotAllowCommentException();
        }
    }

    private void scanSingleLineComment() {
        Token lastToken = this.token;
        this.scanChar();
        this.scanChar();
        this.mark = this.pos;
        this.bufPos = 0;
        while (true) {
            if (this.ch == '\r') {
                if (this.charAt(this.pos + 1) == '\n') {
                    ++this.line;
                    this.scanChar();
                    break;
                }
                ++this.bufPos;
                break;
            }
            if (this.ch == '\n') {
                ++this.line;
                this.scanChar();
                break;
            }
            if (this.ch == '\u001a') {
                throw new ParserException("syntax error at end of input. " + this.info());
            }
            this.scanChar();
            ++this.bufPos;
        }
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.LINE_COMMENT;
        ++this.commentCount;
        if (this.keepComments) {
            this.addComment(this.stringVal);
        }
        if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
            return;
        }
        if (!this.isAllowComment() && !this.isSafeComment(this.stringVal)) {
            throw new NotAllowCommentException();
        }
    }

    public void scanIdentifier() {
        int ch;
        this.hash_lower = 0L;
        this.hash = 0L;
        char first = this.ch;
        if (this.ch == '`') {
            this.mark = this.pos;
            this.bufPos = 1;
            int startPos = this.pos + 1;
            int quoteIndex = this.text.indexOf(96, startPos);
            if (quoteIndex == -1) {
                throw new ParserException("illegal identifier. " + this.info());
            }
            this.hash_lower = -3750763034362895579L;
            this.hash = -3750763034362895579L;
            for (int i = startPos; i < quoteIndex; ++i) {
                int ch2 = this.text.charAt(i);
                this.hash_lower ^= (long)(ch2 >= 65 && ch2 <= 90 ? ch2 + 32 : ch2);
                this.hash_lower *= 1099511628211L;
                this.hash ^= (long)ch2;
                this.hash *= 1099511628211L;
            }
            this.stringVal = MySqlLexer.quoteTable.addSymbol(this.text, this.pos, quoteIndex + 1 - this.pos, this.hash);
            this.pos = quoteIndex + 1;
            this.ch = this.charAt(this.pos);
            this.token = Token.IDENTIFIER;
            return;
        }
        boolean firstFlag = CharTypes.isFirstIdentifierChar(first);
        if (!firstFlag) {
            throw new ParserException("illegal identifier. " + this.info());
        }
        this.hash_lower = -3750763034362895579L;
        this.hash = -3750763034362895579L;
        this.hash_lower ^= (long)(this.ch >= 'A' && this.ch <= 'Z' ? this.ch + 32 : this.ch);
        this.hash_lower *= 1099511628211L;
        this.hash ^= (long)this.ch;
        this.hash *= 1099511628211L;
        this.mark = this.pos;
        this.bufPos = 1;
        while (CharTypes.isIdentifierChar((char)(ch = this.charAt(++this.pos)))) {
            this.hash_lower ^= (long)(ch >= 65 && ch <= 90 ? ch + 32 : ch);
            this.hash_lower *= 1099511628211L;
            this.hash ^= (long)ch;
            this.hash *= 1099511628211L;
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        if (this.bufPos == 1) {
            this.token = Token.IDENTIFIER;
            this.stringVal = CharTypes.valueOf(first);
            if (this.stringVal == null) {
                this.stringVal = Character.toString(first);
            }
            return;
        }
        Token tok = this.keywods.getKeyword(this.hash_lower);
        if (tok != null) {
            this.token = tok;
            this.stringVal = this.token == Token.IDENTIFIER ? SymbolTable.global.addSymbol(this.text, this.mark, this.bufPos, this.hash) : null;
        } else {
            this.token = Token.IDENTIFIER;
            this.stringVal = SymbolTable.global.addSymbol(this.text, this.mark, this.bufPos, this.hash);
        }
    }

    public void scanNumber() {
        this.mark = this.pos++;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            if (this.charAt(this.pos + 1) == '.') {
                this.token = Token.LITERAL_INT;
                return;
            }
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            if (this.ch == '+' || this.ch == '-') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            isDouble = true;
        }
        this.token = isDouble ? Token.LITERAL_FLOAT : Token.LITERAL_INT;
    }

    public void scanHexaDecimal() {
        this.mark = this.pos++;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (CharTypes.isHex(this.ch)) {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        this.token = Token.LITERAL_HEX;
    }

    public String hexString() {
        return this.subString(this.mark, this.bufPos);
    }

    public final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected final void putChar(char ch) {
        if (this.bufPos == this.buf.length) {
            char[] newsbuf = new char[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newsbuf, 0, this.buf.length);
            this.buf = newsbuf;
        }
        this.buf[this.bufPos++] = ch;
    }

    public final int pos() {
        return this.pos;
    }

    public final String stringVal() {
        if (this.stringVal == null) {
            this.stringVal = this.subString(this.mark, this.bufPos);
        }
        return this.stringVal;
    }

    private final void stringVal(StringBuffer out) {
        if (this.stringVal != null) {
            out.append(this.stringVal);
            return;
        }
        out.append(this.text, this.mark, this.mark + this.bufPos);
    }

    public final boolean identifierEquals(String text) {
        if (this.token != Token.IDENTIFIER) {
            return false;
        }
        if (this.stringVal == null) {
            this.stringVal = this.subString(this.mark, this.bufPos);
        }
        return text.equalsIgnoreCase(this.stringVal);
    }

    public final boolean identifierEquals(long hash_lower) {
        if (this.token != Token.IDENTIFIER) {
            return false;
        }
        if (this.hash_lower == 0L) {
            if (this.stringVal == null) {
                this.stringVal = this.subString(this.mark, this.bufPos);
            }
            this.hash_lower = FnvHash.fnv1a_64_lower(this.stringVal);
        }
        return this.hash_lower == hash_lower;
    }

    public final long hash_lower() {
        if (this.hash_lower == 0L) {
            if (this.stringVal == null) {
                this.stringVal = this.subString(this.mark, this.bufPos);
            }
            this.hash_lower = FnvHash.fnv1a_64_lower(this.stringVal);
        }
        return this.hash_lower;
    }

    public final List<String> readAndResetComments() {
        List<String> comments = this.comments;
        this.comments = null;
        return comments;
    }

    private boolean isOperator(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public Number integerValue() {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.mark;
        int max = this.mark + this.bufPos;
        if (this.charAt(this.mark) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = this.charAt(i++) - 48;
            result = -digit;
        }
        while (i < max) {
            digit = this.charAt(i++) - 48;
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.mark + 1) {
                if (result >= Integer.MIN_VALUE) {
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE) {
            return (int)result;
        }
        return result;
    }

    public int bp() {
        return this.pos;
    }

    public char current() {
        return this.ch;
    }

    public void reset(int mark, char markChar, Token token) {
        this.pos = mark;
        this.ch = markChar;
        this.token = token;
    }

    public final String numberString() {
        return this.subString(this.mark, this.bufPos);
    }

    public BigDecimal decimalValue() {
        char[] value = this.sub_chars(this.mark, this.bufPos);
        if (!StringUtils.isNumber(value)) {
            throw new ParserException(value + " is not a number! " + this.info());
        }
        return new BigDecimal(value);
    }

    public SQLNumberExpr numberExpr() {
        char[] value = this.sub_chars(this.mark, this.bufPos);
        if (!StringUtils.isNumber(value)) {
            throw new ParserException(value + " is not a number! " + this.info());
        }
        return new SQLNumberExpr(value);
    }

    public SQLNumberExpr numberExpr(boolean negate) {
        char[] value = this.sub_chars(this.mark, this.bufPos);
        if (!StringUtils.isNumber(value)) {
            throw new ParserException(value + " is not a number! " + this.info());
        }
        if (negate) {
            char[] chars = new char[value.length + 1];
            chars[0] = 45;
            System.arraycopy(value, 0, chars, 1, value.length);
            return new SQLNumberExpr(chars);
        }
        return new SQLNumberExpr(value);
    }

    public boolean hasComment() {
        return this.comments != null;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public void skipToEOF() {
        this.pos = this.text.length();
        this.token = Token.EOF;
    }

    public boolean isEndOfComment() {
        return this.endOfComment;
    }

    protected boolean isSafeComment(String comment) {
        if (comment == null) {
            return true;
        }
        return (comment = comment.toLowerCase()).indexOf("select") == -1 && comment.indexOf("delete") == -1 && comment.indexOf("insert") == -1 && comment.indexOf("update") == -1 && comment.indexOf("into") == -1 && comment.indexOf("where") == -1 && comment.indexOf("or") == -1 && comment.indexOf("and") == -1 && comment.indexOf("union") == -1 && comment.indexOf(39) == -1 && comment.indexOf(61) == -1 && comment.indexOf(62) == -1 && comment.indexOf(60) == -1 && comment.indexOf(38) == -1 && comment.indexOf(124) == -1 && comment.indexOf(94) == -1;
    }

    protected void addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>(2);
        }
        this.comments.add(this.stringVal);
    }

    public int getLine() {
        return this.line;
    }

    public void computeRowAndColumn() {
        int line = 1;
        boolean column = true;
        for (int i = 0; i < this.pos; ++i) {
            char ch = this.text.charAt(i);
            if (ch != '\n') continue;
            column = true;
            ++line;
        }
        this.posLine = line;
        this.posColumn = this.posColumn;
    }

    public int getPosLine() {
        return this.posLine;
    }

    public int getPosColumn() {
        return this.posColumn;
    }

    public void config(SQLParserFeature feature, boolean state) {
        this.features = SQLParserFeature.config(this.features, feature, state);
        if (feature == SQLParserFeature.OptimizedForParameterized) {
            this.optimizedForParameterized = state;
        } else if (feature == SQLParserFeature.KeepComments) {
            this.keepComments = state;
        } else if (feature == SQLParserFeature.SkipComments) {
            this.skipComment = state;
        }
    }

    public final boolean isEnabled(SQLParserFeature feature) {
        return SQLParserFeature.isEnabled(this.features, feature);
    }

    public static String parameterize(String sql, String dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.optimizedForParameterized = true;
        lexer.nextToken();
        StringBuffer buf = new StringBuffer();
        block9: while (true) {
            Token token = lexer.token;
            switch (token) {
                case LITERAL_ALIAS: 
                case LITERAL_FLOAT: 
                case LITERAL_CHARS: 
                case LITERAL_INT: 
                case LITERAL_NCHARS: 
                case LITERAL_HEX: 
                case VARIANT: {
                    if (buf.length() != 0) {
                        buf.append(' ');
                    }
                    buf.append('?');
                    break;
                }
                case COMMA: {
                    buf.append(',');
                    break;
                }
                case EQ: {
                    buf.append('=');
                    break;
                }
                case EOF: {
                    break block9;
                }
                case ERROR: {
                    return sql;
                }
                case SELECT: {
                    buf.append("SELECT");
                    break;
                }
                case UPDATE: {
                    buf.append("UPDATE");
                    break;
                }
                default: {
                    if (buf.length() != 0) {
                        buf.append(' ');
                    }
                    lexer.stringVal(buf);
                }
            }
            lexer.nextToken();
        }
        return buf.toString();
    }

    public String getSource() {
        return this.text;
    }

    static {
        for (int i = 48; i <= 57; ++i) {
            Lexer.digits[i] = i - 48;
        }
    }

    public static interface CommentHandler {
        public boolean handle(Token var1, String var2);
    }

    public static class SavePoint {
        int bp;
        int sp;
        int np;
        char ch;
        long hash;
        long hash_lower;
        public Token token;
        String stringVal;
    }
}

