/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.visitor;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithQuery;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGParameter;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import java.util.Map;

public class PGSchemaStatVisitor
extends SchemaStatVisitor
implements PGASTVisitor {
    @Override
    public String getDbType() {
        return "postgresql";
    }

    @Override
    public void endVisit(PGSelectQueryBlock.WindowClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.WindowClause x) {
        return true;
    }

    @Override
    public void endVisit(PGSelectQueryBlock.FetchClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.FetchClause x) {
        return true;
    }

    @Override
    public void endVisit(PGSelectQueryBlock.ForClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.ForClause x) {
        return true;
    }

    @Override
    public void endVisit(PGWithQuery x) {
    }

    @Override
    public boolean visit(PGWithQuery x) {
        Map<String, String> aliasMap = this.getAliasMap();
        if (aliasMap != null) {
            String alias = null;
            if (x.getName() != null) {
                alias = x.getName().toString();
            }
            if (alias != null) {
                aliasMap.put(alias, null);
                this.subQueryMap.put(alias, x.getQuery());
            }
        }
        x.getQuery().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGWithClause x) {
    }

    @Override
    public boolean visit(PGWithClause x) {
        return true;
    }

    @Override
    public void endVisit(PGDeleteStatement x) {
    }

    @Override
    public boolean visit(PGDeleteStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        this.setAliasMap();
        for (SQLName name : x.getUsing()) {
            String ident = name.toString();
            TableStat stat = this.getTableStat(ident);
            stat.incrementSelectCount();
            Map<String, String> aliasMap = this.getAliasMap();
            if (aliasMap == null) continue;
            aliasMap.put(ident, ident);
        }
        x.putAttribute("_original_use_mode", (Object)this.getMode());
        this.setMode(x, TableStat.Mode.Delete);
        String ident = ((SQLIdentifierExpr)x.getTableName()).getName();
        this.setCurrentTable(ident);
        TableStat stat = this.getTableStat(ident, x.getAlias());
        stat.incrementDeleteCount();
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public void endVisit(PGInsertStatement x) {
    }

    @Override
    public boolean visit(PGInsertStatement x) {
        this.setAliasMap();
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        x.putAttribute("_original_use_mode", (Object)this.getMode());
        this.setMode(x, TableStat.Mode.Insert);
        String originalTable = this.getCurrentTable();
        if (x.getTableName() instanceof SQLName) {
            String ident = x.getTableName().toString();
            this.setCurrentTable(ident);
            x.putAttribute("_old_local_", originalTable);
            TableStat stat = this.getTableStat(ident);
            stat.incrementInsertCount();
            Map<String, String> aliasMap = this.getAliasMap();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
        }
        this.accept(x.getColumns());
        this.accept(x.getQuery());
        return false;
    }

    @Override
    public void endVisit(PGSelectStatement x) {
    }

    @Override
    public boolean visit(PGSelectStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        return this.visit((SQLSelectStatement)x);
    }

    @Override
    public void endVisit(PGUpdateStatement x) {
    }

    @Override
    public boolean visit(PGUpdateStatement x) {
        Map<String, String> oldAliasMap = this.getAliasMap();
        this.setAliasMap();
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        String ident = x.getTableName().toString();
        this.setCurrentTable(ident);
        TableStat stat = this.getTableStat(ident);
        stat.incrementUpdateCount();
        Map<String, String> aliasMap = this.getAliasMap();
        aliasMap.put(ident, ident);
        this.accept(x.getItems());
        this.accept(x.getWhere());
        this.setAliasMap(oldAliasMap);
        return false;
    }

    @Override
    public void endVisit(PGSelectQueryBlock x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock x) {
        return this.visit((SQLSelectQueryBlock)x);
    }

    @Override
    public void endVisit(PGParameter x) {
    }

    @Override
    public boolean visit(PGParameter x) {
        return false;
    }

    @Override
    public void endVisit(PGFunctionTableSource x) {
    }

    @Override
    public boolean visit(PGFunctionTableSource x) {
        return true;
    }
}

