/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.GlobalMailAccount;
import cn.hutool.extra.mail.Mail;
import cn.hutool.extra.mail.MailAccount;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MailUtil {
    public static void sendText(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, false, files);
    }

    public static void sendHtml(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, true, files);
    }

    public static void send(String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), MailUtil.splitAddress(cc), MailUtil.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static void sendText(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, false, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, true, files);
    }

    public static void send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(tos, null, null, subject, content, isHtml, files);
    }

    public static void send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(GlobalMailAccount.INSTANCE.getAccount(), true, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static void send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, MailUtil.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, tos, null, null, subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, false, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static void sendHtml(String to, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        MailUtil.send(to, subject, content, imageMap, true, files);
    }

    public static void send(String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static void send(String to, String cc, String bcc, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), MailUtil.splitAddress(cc), MailUtil.splitAddress(bcc), subject, content, imageMap, isHtml, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        MailUtil.send(tos, subject, content, imageMap, true, files);
    }

    public static void send(Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        MailUtil.send(tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static void send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        MailUtil.send(GlobalMailAccount.INSTANCE.getAccount(), true, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    public static void send(MailAccount mailAccount, String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, MailUtil.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, false, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    private static void send(MailAccount mailAccount, boolean useGlobalSession, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        Mail mail = Mail.create(mailAccount).setUseGlobalSession(useGlobalSession);
        if (CollUtil.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[ccs.size()]));
        }
        if (CollUtil.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[bccs.size()]));
        }
        mail.setTos(tos.toArray(new String[tos.size()]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        if (MapUtil.isNotEmpty(imageMap)) {
            for (Map.Entry<String, InputStream> entry : imageMap.entrySet()) {
                mail.addImage(entry.getKey(), entry.getValue());
                IoUtil.close((Closeable)entry.getValue());
            }
        }
        mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (StrUtil.isBlank((CharSequence)addresses)) {
            return null;
        }
        List result = StrUtil.contains((CharSequence)addresses, (char)',') ? StrUtil.splitTrim((CharSequence)addresses, (char)',') : (StrUtil.contains((CharSequence)addresses, (char)';') ? StrUtil.splitTrim((CharSequence)addresses, (char)';') : CollUtil.newArrayList((Object[])new String[]{addresses}));
        return result;
    }
}

