/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisClusterAsyncConnection;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterAsyncConnection;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import io.netty.channel.ChannelHandler;
import java.util.List;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class RedisAdvancedClusterAsyncConnectionImpl<K, V>
extends RedisAsyncConnectionImpl<K, V>
implements RedisAdvancedClusterAsyncConnection<K, V> {
    private Partitions partitions;

    public RedisAdvancedClusterAsyncConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, codec, timeout, unit);
    }

    ClusterDistributionChannelWriter<K, V> getWriter() {
        return (ClusterDistributionChannelWriter)super.getChannelWriter();
    }

    @Override
    public RedisClusterAsyncConnection<K, V> getConnection(String nodeId) {
        RedisAsyncConnectionImpl connection = this.getWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, nodeId);
        return connection;
    }

    @Override
    public RedisFuture<List<K>> clusterGetKeysInSlot(int slot, int count) {
        RedisClusterAsyncConnection<K, V> connectionBySlot = this.findConnectionBySlot(slot);
        if (connectionBySlot != null) {
            return connectionBySlot.clusterGetKeysInSlot(slot, count);
        }
        return super.clusterGetKeysInSlot(slot, count);
    }

    @Override
    public RedisFuture<Long> clusterCountKeysInSlot(int slot) {
        RedisClusterAsyncConnection<K, V> connectionBySlot = this.findConnectionBySlot(slot);
        if (connectionBySlot != null) {
            return connectionBySlot.clusterCountKeysInSlot(slot);
        }
        return super.clusterCountKeysInSlot(slot);
    }

    private RedisClusterAsyncConnection<K, V> findConnectionBySlot(int slot) {
        RedisClusterNode node = this.partitions.getPartitionBySlot(slot);
        if (node != null) {
            return this.getConnection(node.getUri().getHost(), node.getUri().getPort());
        }
        return null;
    }

    @Override
    public RedisClusterAsyncConnection<K, V> getConnection(String host, int port) {
        RedisAsyncConnectionImpl connection = this.getWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, host, port);
        return connection;
    }

    public void setPartitions(Partitions partitions) {
        this.getWriter().getClusterConnectionProvider().setPartitions(partitions);
        this.partitions = partitions;
    }

    @Override
    public void setReadFrom(ReadFrom readFrom) {
        Preconditions.checkArgument((readFrom != null ? 1 : 0) != 0, (Object)"readFrom must not be null");
        this.getWriter().setReadFrom(readFrom);
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.getWriter().getReadFrom();
    }
}

