/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock.commands;

import ai.grakn.redismock.RedisBase;
import ai.grakn.redismock.Response;
import ai.grakn.redismock.Slice;
import ai.grakn.redismock.commands.AbstractRedisOperation;
import java.util.ArrayList;
import java.util.List;

class RO_keys
extends AbstractRedisOperation {
    RO_keys(RedisBase base, List<Slice> params) {
        super(base, params, 1, null, null);
    }

    @Override
    Slice response() {
        ArrayList<Slice> matchingKeys = new ArrayList<Slice>();
        String regex = RO_keys.createRegexFromGlob(new String(this.params().get(0).data()));
        this.base().keys().forEach(keyData -> {
            String key = new String(keyData.data());
            if (key.matches(regex)) {
                matchingKeys.add(Response.bulkString(keyData));
            }
        });
        return Response.array(matchingKeys);
    }

    private static String createRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder("^");
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }
}

